/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkHat;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;

public class LinkType {
    private final LinkHat hat1;
    private final LinkDecor decor1;
    private final LinkStyle linkStyle;
    private final LinkDecor decor2;
    private final LinkHat hat2;
    private final LinkMiddleDecor middleDecor;

    public boolean isDoubleDecorated() {
        return this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public boolean looksLikeRevertedForSvg() {
        return this.decor1 == LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public boolean looksLikeNoDecorAtAllSvg() {
        if (this.decor1 == LinkDecor.NONE && this.decor2 == LinkDecor.NONE) {
            return true;
        }
        return this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE;
    }

    public LinkType(LinkDecor decor1, LinkDecor decor2) {
        this(LinkHat.NONE, decor1, decor2, LinkHat.NONE);
    }

    public LinkType(LinkHat hat1, LinkDecor decor1, LinkDecor decor2, LinkHat hat2) {
        this(hat1, decor1, LinkStyle.NORMAL(), LinkMiddleDecor.NONE, decor2, hat2);
    }

    public LinkType withoutDecors1() {
        return new LinkType(this.hat1, LinkDecor.NONE, this.linkStyle, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType withoutDecors2() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, this.middleDecor, LinkDecor.NONE, this.hat2);
    }

    public String toString() {
        return (Object)((Object)this.decor1) + "-" + this.linkStyle + "-" + (Object)((Object)this.decor2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        LinkType other = (LinkType)obj;
        return this.decor1 == other.decor1 && this.decor2 == other.decor2 && this.linkStyle == other.linkStyle;
    }

    private LinkType(LinkHat hat1, LinkDecor decor1, LinkStyle style, LinkMiddleDecor middleDecor, LinkDecor decor2, LinkHat hat2) {
        this.decor1 = decor1;
        this.linkStyle = Objects.requireNonNull(style);
        this.decor2 = decor2;
        this.middleDecor = middleDecor;
        this.hat1 = hat1;
        this.hat2 = hat2;
    }

    public boolean isInvisible() {
        return this.linkStyle.isInvisible();
    }

    public LinkType goDashed() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DASHED(), this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType goDotted() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DOTTED(), this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType goThickness(double thickness) {
        return new LinkType(this.hat1, this.decor1, this.linkStyle.goThickness(thickness), this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType goBold() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.BOLD(), this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInversed() {
        return new LinkType(this.hat2, this.decor2, this.linkStyle, this.middleDecor.getInversed(), this.decor1, this.hat1);
    }

    public LinkType withMiddleCircle() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, LinkMiddleDecor.CIRCLE, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, LinkMiddleDecor.CIRCLE_CIRCLED, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled1() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, LinkMiddleDecor.CIRCLE_CIRCLED1, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled2() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, LinkMiddleDecor.CIRCLE_CIRCLED2, this.decor2, this.hat2);
    }

    public LinkType getInvisible() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.INVISIBLE(), this.middleDecor, this.decor2, this.hat2);
    }

    public String getSpecificDecorationSvek() {
        boolean isEmpty2;
        StringBuilder sb = new StringBuilder();
        boolean isEmpty1 = this.decor1 == LinkDecor.NONE && this.hat1 == LinkHat.NONE;
        boolean bl = isEmpty2 = this.decor2 == LinkDecor.NONE && this.hat2 == LinkHat.NONE;
        if (isEmpty1 && isEmpty2) {
            sb.append("arrowtail=none");
            sb.append(",arrowhead=none");
        } else if (!isEmpty1 && !isEmpty2) {
            sb.append("dir=both,");
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=empty");
        } else if (isEmpty1 && !isEmpty2) {
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=none");
            sb.append(",dir=back");
        }
        double arrowsize = Math.max(this.decor1.getArrowSize(), this.decor2.getArrowSize());
        if (arrowsize > 0.0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("arrowsize=" + arrowsize);
        }
        return sb.toString();
    }

    public final LinkDecor getDecor1() {
        return this.decor1;
    }

    public final LinkStyle getStyle() {
        return this.linkStyle;
    }

    public final LinkDecor getDecor2() {
        return this.decor2;
    }

    private boolean isExtendsOrAggregationOrCompositionOrPlus() {
        return this.isExtends() || this.isAggregationOrComposition() || this.isPlus() || this.isOf(LinkDecor.DEFINEDBY) || this.isOf(LinkDecor.REDEFINES);
    }

    private boolean isOf(LinkDecor ld) {
        return this.decor1 == ld || this.decor2 == ld;
    }

    private boolean isExtends() {
        return this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS;
    }

    private boolean isPlus() {
        return this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS;
    }

    private boolean isAggregationOrComposition() {
        return this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION || this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION;
    }

    public LinkType getPart1() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, this.middleDecor, LinkDecor.NONE, LinkHat.NONE);
    }

    public LinkType getPart2() {
        return new LinkType(LinkHat.NONE, LinkDecor.NONE, this.linkStyle, this.middleDecor, this.decor2, this.hat2);
    }

    public UStroke getStroke3(UStroke defaultThickness) {
        if (this.linkStyle.isThicknessOverrided()) {
            return this.linkStyle.getStroke3();
        }
        if (defaultThickness == null) {
            return this.linkStyle.getStroke3();
        }
        if (defaultThickness.getDashVisible() == 0.0 && defaultThickness.getDashSpace() == 0.0) {
            return this.linkStyle.goThickness(defaultThickness.getThickness()).getStroke3();
        }
        return defaultThickness;
    }

    public LinkMiddleDecor getMiddleDecor() {
        return this.middleDecor;
    }

    public LinkHat getHat1() {
        return this.hat1;
    }

    public LinkHat getHat2() {
        return this.hat2;
    }

    public LinkType withLollipopInterfaceEye2() {
        return new LinkType(this.hat1, LinkDecor.NONE, this.linkStyle, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType withLollipopInterfaceEye1() {
        return new LinkType(this.hat1, this.decor1, this.linkStyle, this.middleDecor, LinkDecor.NONE, this.hat2);
    }
}

