/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.directdot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.CounterOutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class PSystemDot
extends AbstractPSystem {
    private final String data;

    public PSystemDot(UmlSource source, String data) {
        super(source);
        this.data = data;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dot)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        Graphviz graphviz = GraphvizUtils.createForSystemDot(null, this.data, StringUtils.goLowerCase(fileFormat.getFileFormat().name()));
        if (graphviz.getExeState() != ExeState.OK) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("There is an issue with your Dot/Graphviz installation"), false);
            return ImageBuilder.plainImageBuilder(result, fileFormat).seed(this.seed()).status(503).write(os);
        }
        CounterOutputStream counter = new CounterOutputStream(os);
        ProcessState state = graphviz.createFile3(counter);
        if (counter.getLength() == 0 || state.differs(ProcessState.TERMINATED_OK())) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("GraphViz has crashed"), false);
            return ImageBuilder.plainImageBuilder(result, fileFormat).seed(this.seed()).status(503).write(os);
        }
        return ImageDataSimple.ok();
    }
}

