/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.emoji;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.PlainDiagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.emoji.Emoji;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class PSystemListEmoji
extends PlainDiagram {
    private final String text;

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b><size:16>Emoji available on Unicode Block " + PSystemListEmoji.this.text, "(Blocks available: 26, 27, 1F3, 1F4, 1F5, 1F6, 1F9)"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                UGraphic top = ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                TreeMap<String, Emoji> some = new TreeMap<String, Emoji>();
                for (Map.Entry<String, Emoji> ent : Emoji.getAll().entrySet()) {
                    if (!ent.getKey().startsWith(PSystemListEmoji.this.text)) continue;
                    some.put(ent.getKey(), ent.getValue());
                }
                int third = (some.size() + 2) / 3;
                int i = 0;
                for (Map.Entry ent : some.entrySet()) {
                    String code = (String)ent.getKey();
                    String shortcut = ((Emoji)ent.getValue()).getShortcut();
                    StringBuilder sb = new StringBuilder();
                    sb.append("<size:13>");
                    sb.append("\"\"<U+003C>:" + code + ":<U+003E> \"\"");
                    sb.append("<:" + code + ":>");
                    sb.append(" ");
                    sb.append("<#0:" + code + ":>");
                    if (shortcut != null) {
                        sb.append(" ");
                        sb.append("\"\"<U+003C>:" + shortcut + ":<U+003E> \"\"");
                    }
                    TextBlockBackcolored tmp = GraphicStrings.createBlackOnWhite(Arrays.asList(sb.toString()));
                    tmp.drawU(ug);
                    ug = ug.apply(UTranslate.dy(tmp.calculateDimension(stringBounder).getHeight()));
                    if (++i == third) {
                        ug = top.apply(UTranslate.dx(500.0));
                    }
                    if (i != 2 * third) continue;
                    ug = top.apply(UTranslate.dx(1000.0));
                }
            }
        };
    }

    public PSystemListEmoji(UmlSource source, String text) {
        super(source);
        this.text = text;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(List Emoji)");
    }
}

