/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.graphic.FontChange;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

class ColorAndSizeChange
implements FontChange {
    static final Pattern2 colorPattern = MyPattern.cmpile("color\\s*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?");
    static final Pattern2 sizePattern = MyPattern.cmpile("size\\s*=\\s*[%g]?(\\d+)[%g]?");
    private final HColor color;
    private final Integer size;

    ColorAndSizeChange(ThemeStyle themeStyle, String s2) {
        Matcher2 matcherColor = colorPattern.matcher(s2);
        if (matcherColor.find()) {
            String s1 = matcherColor.group(1);
            this.color = HColorSet.instance().getColorOrWhite(themeStyle, s1);
        } else {
            this.color = null;
        }
        Matcher2 matcherSize = sizePattern.matcher(s2);
        this.size = matcherSize.find() ? Integer.valueOf(matcherSize.group(1)) : null;
    }

    HColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    @Override
    public FontConfiguration apply(FontConfiguration initial) {
        FontConfiguration result = initial;
        if (this.color != null) {
            result = result.changeColor(this.color);
        }
        if (this.size != null) {
            result = result.changeSize(this.size.intValue());
        }
        return result;
    }
}

