/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicPosition;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockRaw;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.ugraphic.PixelImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final double margin = 5.0;
    private final HColor background;
    private static final HColor hyperlinkColor = HColorUtils.BLUE;
    private static final boolean useUnderlineForHyperlink = true;
    private final List<String> strings;
    private final BufferedImage image;
    private final double imagePadding = 30.0;
    private final GraphicPosition position;
    private final FontConfiguration fontConfiguration;
    private final CreoleMode mode;

    public static IEntityImage createForError(List<String> strings, boolean useRed) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif14(GraphicStrings.getForeColor(useRed)).bold(), GraphicStrings.getBackColor(useRed), null, null, CreoleMode.NO_CREOLE);
    }

    private static HColor getForeColor(boolean useRed) {
        if (useRed) {
            return HColorUtils.BLACK;
        }
        return HColorUtils.MY_GREEN;
    }

    private static HColor getBackColor(boolean useRed) {
        if (useRed) {
            return HColorUtils.RED_LIGHT;
        }
        return HColorUtils.BLACK;
    }

    public static TextBlockBackcolored createGreenOnBlackMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(HColorUtils.GREEN), HColorUtils.BLACK, null, null, CreoleMode.SIMPLE_LINE);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(HColorUtils.BLACK), HColorUtils.WHITE, null, null, CreoleMode.FULL);
    }

    public static TextBlockBackcolored createBlackOnWhiteMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(HColorUtils.BLACK), HColorUtils.WHITE, null, null, CreoleMode.FULL);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings, BufferedImage image, GraphicPosition position) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(HColorUtils.BLACK), HColorUtils.WHITE, image, position, CreoleMode.FULL);
    }

    public static FontConfiguration sansSerif12(HColor color) {
        return FontConfiguration.create(UFont.sansSerif(12), color, hyperlinkColor, true);
    }

    public static FontConfiguration sansSerif14(HColor color) {
        return FontConfiguration.create(UFont.sansSerif(14), color, hyperlinkColor, true);
    }

    private static FontConfiguration monospaced14(HColor color) {
        return FontConfiguration.create(UFont.monospaced(14), color, hyperlinkColor, true);
    }

    private GraphicStrings(List<String> strings, FontConfiguration fontConfiguration, HColor background, BufferedImage image, GraphicPosition position, CreoleMode mode) {
        this.strings = strings;
        this.background = background;
        this.image = image;
        this.position = position;
        this.mode = mode;
        this.fontConfiguration = fontConfiguration;
    }

    private TextBlock getTextBlock() {
        Display display = Display.create(this.strings);
        if (this.mode == CreoleMode.NO_CREOLE) {
            return new TextBlockRaw(this.strings, this.fontConfiguration);
        }
        return display.create7(this.fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty(), this.mode);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        Dimension2D size = this.calculateDimensionInternal(ug.getStringBounder());
        this.getTextBlock().drawU(ug.apply(this.fontConfiguration.getColor()));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                ug.apply(new UTranslate((size.getWidth() - (double)this.image.getWidth()) / 2.0, size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth(), size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.calculateDimensionInternal(stringBounder), 10.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dim = this.getTextBlock().calculateDimension(stringBounder);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dim = new Dimension2DDouble(dim.getWidth(), dim.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            }
        }
        return dim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HColor getBackcolor() {
        return this.background;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

