/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkStyle;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class HtmlColorAndStyle {
    private final HColor arrowHeadColor;
    private final HColor arrowColor;
    private final LinkStyle style;

    public String toString() {
        return this.arrowColor + " " + this.style;
    }

    public HtmlColorAndStyle(HColor color, HColor arrowHeadColor) {
        this(color, LinkStyle.NORMAL(), arrowHeadColor);
    }

    public HtmlColorAndStyle(HColor arrowColor, LinkStyle style, HColor arrowHeadColor) {
        this.arrowColor = Objects.requireNonNull(arrowColor);
        this.arrowHeadColor = arrowHeadColor == null ? arrowColor : arrowHeadColor;
        this.style = style;
    }

    public HColor getArrowColor() {
        return this.arrowColor;
    }

    public HColor getArrowHeadColor() {
        return this.arrowHeadColor;
    }

    public LinkStyle getStyle() {
        return this.style;
    }

    public static final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public static HtmlColorAndStyle build(ISkinParam skinParam, String definition) throws NoSuchColorException {
        Style style = HtmlColorAndStyle.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor arrowColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        HColor arrowHeadColor = null;
        LinkStyle linkStyle = LinkStyle.NORMAL();
        HColorSet set = skinParam.getIHtmlColorSet();
        for (String s2 : definition.split(",")) {
            HColor tmpColor;
            LinkStyle tmpStyle = LinkStyle.fromString1(s2);
            if (!tmpStyle.isNormal()) {
                linkStyle = tmpStyle;
                continue;
            }
            HColor hColor = tmpColor = s2 == null ? null : set.getColor(skinParam.getThemeStyle(), s2);
            if (tmpColor == null) continue;
            arrowColor = tmpColor;
        }
        return new HtmlColorAndStyle(arrowColor, linkStyle, arrowHeadColor);
    }
}

