/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class TextBlockLineBefore
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;
    private final double defaultThickness;

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock, char separator, TextBlock title) {
        this.textBlock = textBlock;
        this.separator = separator;
        this.title = title;
        this.defaultThickness = defaultThickness;
    }

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock, char separator) {
        this(defaultThickness, textBlock, separator, null);
    }

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock) {
        this(defaultThickness, textBlock, '\u0000');
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimTitle = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dim, dimTitle.getWidth() + 8.0, dimTitle.getHeight());
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = ug.getParam().getColor();
        if (this.title == null) {
            UHorizontalLine.infinite(this.defaultThickness, 1.0, 1.0, this.separator).drawMe(ug);
        }
        this.textBlock.drawU(ug);
        ug = color == null ? ug.apply(new HColorNone()) : ug.apply(color);
        if (this.title != null) {
            UHorizontalLine.infinite(this.defaultThickness, 1.0, 1.0, this.title, this.separator).drawMe(ug);
        }
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.textBlock.getInnerPosition(member, stringBounder, strategy);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        if (this.textBlock instanceof WithPorts) {
            return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder);
        }
        return new Ports();
    }
}

