/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileText
extends AbstractTextBlock
implements TextBlock {
    private final String text;
    private final FontConfiguration fontConfiguration;
    private final Url url;

    public TileText(String text, FontConfiguration fontConfiguration, Url url) {
        this.fontConfiguration = fontConfiguration;
        this.text = text;
        this.url = url;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        int spaceBottom = Math.abs(this.fontConfiguration.getSpace());
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h2 = rect.getHeight();
        if (h2 < 10.0) {
            h2 = 10.0;
        }
        double width = this.text.indexOf(9) == -1 ? rect.getWidth() : this.getWidth(stringBounder);
        return new Dimension2DDouble(width, h2 + (double)spaceBottom);
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.fontConfiguration.getColor());
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        if (tokenizer.hasMoreTokens()) {
            double tabSize = this.getTabSize(ug.getStringBounder());
            while (tokenizer.hasMoreTokens()) {
                String s2 = tokenizer.nextToken();
                if (s2.equals("\t")) {
                    double remainder = x % tabSize;
                    x += tabSize - remainder;
                    continue;
                }
                UText utext = new UText(s2, this.fontConfiguration);
                Dimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s2);
                int space = this.fontConfiguration.getSpace();
                double ypos = space < 0 ? (double)space : (double)space;
                ug.apply(new UTranslate(x, ypos)).draw(utext);
                x += dim.getWidth();
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    double getWidth(StringBounder stringBounder) {
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s2 = tokenizer.nextToken();
            if (s2.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            x += dim.getWidth();
        }
        return x;
    }
}

