/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SpecialText;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

class USymbolFrame
extends USymbol {
    USymbolFrame() {
    }

    @Override
    public SName getSName() {
        return SName.frame;
    }

    private void drawFrame(UGraphic ug, double width, double height, Dimension2D dimTitle, double shadowing, double roundCorner) {
        int cornersize;
        double textWidth;
        URectangle shape = new URectangle(width, height).rounded(roundCorner).ignoreForCompressionOnX().ignoreForCompressionOnY();
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
        if (dimTitle.getWidth() == 0.0) {
            textWidth = width / 3.0;
            cornersize = 7;
        } else {
            textWidth = dimTitle.getWidth() + 10.0;
            cornersize = 10;
        }
        double textHeight = this.getYpos(dimTitle);
        UPath polygon = new UPath();
        polygon.setIgnoreForCompressionOnX();
        polygon.moveTo(textWidth, 0.0);
        polygon.lineTo(textWidth, textHeight - (double)cornersize);
        polygon.lineTo(textWidth - (double)cornersize, textHeight);
        polygon.lineTo(0.0, textHeight);
        ug.apply(new HColorNone().bg()).draw(polygon);
    }

    private double getYpos(Dimension2D dimTitle) {
        if (dimTitle.getWidth() == 0.0) {
            return 12.0;
        }
        return dimTitle.getHeight() + 3.0;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolFrame.this.drawFrame(ug, dim.getWidth(), dim.getHeight(), new Dimension2DDouble(0.0, 0.0), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolFrame.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolFrame.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                Dimension2D dim = this.calculateDimension(stringBounder);
                ug = symbolContext.apply(ug);
                Dimension2D dimTitle = title.calculateDimension(stringBounder);
                double widthFull = dim.getWidth();
                USymbolFrame.this.drawFrame(ug, widthFull, dim.getHeight(), dimTitle, symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                double widthTitle = title.calculateDimension(stringBounder).getWidth();
                if (widthFull - widthTitle < 25.0) {
                    title.drawU(ug.apply(new UTranslate(3.0, 1.0)));
                } else {
                    ug.apply(new UTranslate(3.0, 1.0)).draw(new SpecialText(title));
                }
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(4.0 + posStereo, 2.0 + USymbolFrame.this.getYpos(dimTitle))));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

