/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolPerson
extends USymbol {
    USymbolPerson() {
    }

    @Override
    public SName getSName() {
        return SName.person;
    }

    private void drawHeadAndBody(UGraphic ug, double shadowing, Dimension2D dimBody, double headSize) {
        UEllipse head = new UEllipse(headSize, headSize);
        URectangle body = new URectangle(dimBody).rounded(headSize);
        body.setDeltaShadow(shadowing);
        head.setDeltaShadow(shadowing);
        double posx = (dimBody.getWidth() - headSize) / 2.0;
        ug.apply(UTranslate.dx(posx)).draw(head);
        ug.apply(UTranslate.dy(headSize)).draw(body);
    }

    private double headSize(Dimension2D dimBody) {
        double surface = dimBody.getWidth() * dimBody.getHeight();
        return Math.sqrt(surface) * 0.42;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dimFull = this.calculateDimension(ug.getStringBounder());
                Dimension2D dimBody = this.bodyDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dimFull);
                ug = symbolContext.apply(ug);
                double headSize = USymbolPerson.this.headSize(dimBody);
                USymbolPerson.this.drawHeadAndBody(ug, symbolContext.getDeltaShadow(), dimBody, headSize);
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                USymbol.Margin margin = USymbolPerson.this.getMargin();
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + headSize)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D body = this.bodyDimension(stringBounder);
                return Dimension2DDouble.delta(body, 0.0, USymbolPerson.this.headSize(body));
            }

            private Dimension2D bodyDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolPerson.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        throw new UnsupportedOperationException();
    }
}

