/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.core3.Histogram;
import znaishaded.net.sourceforge.plantuml.project.core3.TimeLine;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;

public class OpenClose
implements Histogram,
LoadPlanable {
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);
    private final Collection<Day> closedDays = new HashSet<Day>();
    private final Collection<Day> openedDays = new HashSet<Day>();
    private Day calendar;

    public int daysInWeek() {
        return 7 - this.closedDayOfWeek.size();
    }

    private boolean isThereSomeChangeAfter(Day day) {
        if (this.closedDayOfWeek.size() > 0) {
            return true;
        }
        for (Day tmp : this.closedDays) {
            if (tmp.compareTo(day) < 0) continue;
            return true;
        }
        for (Day tmp : this.openedDays) {
            if (tmp.compareTo(day) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isThereSomeChangeBefore(Day day) {
        if (this.closedDayOfWeek.size() > 0) {
            return true;
        }
        for (Day tmp : this.closedDays) {
            if (tmp.compareTo(day) > 0) continue;
            return true;
        }
        for (Day tmp : this.openedDays) {
            if (tmp.compareTo(day) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed(Day day) {
        if (this.openedDays.contains(day)) {
            return false;
        }
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        return this.closedDayOfWeek.contains((Object)dayOfWeek) || this.closedDays.contains(day);
    }

    public void close(DayOfWeek day) {
        this.closedDayOfWeek.add(day);
    }

    public void close(Day day) {
        this.closedDays.add(day);
    }

    public void open(Day day) {
        this.openedDays.add(day);
    }

    public final Day getCalendar() {
        return this.calendar;
    }

    public final void setCalendar(Day calendar) {
        this.calendar = calendar;
    }

    @Override
    public long getNext(long moment) {
        int tmp;
        Day day = Day.create(moment);
        if (!this.isThereSomeChangeAfter(day)) {
            return TimeLine.MAX_TIME;
        }
        long current = this.getLoatAtInternal(day);
        System.err.println("getNext:day=" + day + " current=" + current);
        do {
            day = day.increment();
            tmp = this.getLoatAtInternal(day);
            System.err.println("..day=" + day + " " + tmp);
        } while ((long)tmp == current);
        return day.getMillis();
    }

    @Override
    public long getPrevious(long moment) {
        int tmp;
        Day day = Day.create(moment);
        if (!this.isThereSomeChangeBefore(day)) {
            return -TimeLine.MAX_TIME.longValue();
        }
        long current = this.getLoatAtInternal(day);
        System.err.println("getPrevious=" + day + " current=" + current);
        do {
            day = day.decrement();
            tmp = this.getLoatAtInternal(day);
            System.err.println("..day=" + day + " " + tmp);
        } while ((long)tmp == current);
        return day.getMillis();
    }

    @Override
    public long getValueAt(long moment) {
        Day day = Day.create(moment);
        if (this.isClosed(day)) {
            return 0L;
        }
        return 100L;
    }

    @Override
    public int getLoadAt(Day day) {
        if (this.getCalendar() == null) {
            return 100;
        }
        return this.getLoatAtInternal(day);
    }

    private int getLoatAtInternal(Day day) {
        if (this.isClosed(day)) {
            return 0;
        }
        return 100;
    }
}

