/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import java.util.Locale;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.MonthYear;
import znaishaded.net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TimeHeaderWeekly
extends TimeHeaderCalendar {
    private final WeekNumberStrategy weekNumberStrategy;
    private final boolean withCalendarDate;

    @Override
    public double getTimeHeaderHeight() {
        return 29.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 16.0;
    }

    public TimeHeaderWeekly(WeekNumberStrategy weekNumberStrategy, boolean withCalendarDate, Locale locale, Style timelineStyle, Style closedStyle, double scale, Day calendar, Day min2, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, HColorSet colorSet, ThemeStyle themeStyle) {
        super(locale, timelineStyle, closedStyle, calendar, min2, max, defaultPlan, colorDays, colorDaysOfWeek, new TimeScaleCompressed(calendar, scale), colorSet, themeStyle);
        this.weekNumberStrategy = weekNumberStrategy;
        this.withCalendarDate = withCalendarDate;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawCalendar(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.Y_POS_ROW16());
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawHline(ug, 0.0);
        this.printMonths(ug);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawCalendar(UGraphic ug, double totalHeightWithoutFooter) {
        this.printDaysOfMonth(ug);
        this.printSmallVbars(ug, totalHeightWithoutFooter);
        this.printMonths(ug);
    }

    private void printMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVbar(ug, x1, 0.0, this.Y_POS_ROW16());
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, this.Y_POS_ROW16());
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printSmallVbars(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), this.Y_POS_ROW16(), totalHeightWithoutFooter);
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), this.Y_POS_ROW16(), totalHeightWithoutFooter);
    }

    private void printDaysOfMonth(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                String num = this.withCalendarDate ? "" + wink.getDayOfMonth() : "" + wink.getWeekOfYear(this.weekNumberStrategy);
                TextBlock textBlock = this.getTextBlock(num, 10, false, this.openFontColor());
                this.printLeft(ug.apply(UTranslate.dy(this.Y_POS_ROW16())), textBlock, this.getTimeScale().getStartingPosition(wink) + 5.0);
            }
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(monthYear.shortName(this.locale), 12, true, this.openFontColor());
        TextBlock big = this.getTextBlock(monthYear.shortNameYYYY(this.locale), 12, true, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

