/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementClose;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementInColors2;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.Verbs;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class SubjectDayOfWeek
implements Subject {
    @Override
    public IRegex toRegex() {
        return new RegexLeaf("SUBJECT", "(" + DayOfWeek.getRegexString() + ")");
    }

    @Override
    public Failable<? extends Object> getMe(GanttDiagram project, RegexResult arg) {
        String s2 = arg.get("SUBJECT", 0);
        return Failable.ok(DayOfWeek.fromString(s2));
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new AreClose(), new InColor());
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDayOfWeek.this, Verbs.isOrAre(), new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.colorDay(day, color);
            return CommandExecutionResult.ok();
        }
    }

    class AreClose
    extends SentenceSimple {
        public AreClose() {
            super(SubjectDayOfWeek.this, Verbs.are(), new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.closeDayOfWeek(day);
            return CommandExecutionResult.ok();
        }
    }
}

