/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.security;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.ImageIcon;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityCredentials;

public class SURL {
    public static final String WITHOUT_AUTHENTICATION = "<none>";
    private static final Pattern PATTERN_USERINFO = Pattern.compile("(^https?://)([-_0-9a-zA-Z]+@)([^@]*)");
    private static final ExecutorService EXE = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static final Map<String, Long> BAD_HOSTS = new ConcurrentHashMap<String, Long>();
    private final URL internal;
    private final String securityIdentifier;

    private SURL(URL url, String securityIdentifier) {
        this.internal = Objects.requireNonNull(url);
        this.securityIdentifier = Objects.requireNonNull(securityIdentifier);
    }

    public static SURL create(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                return SURL.create(new URL(url));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static SURL create(URL url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("URL cannot be null");
        }
        String credentialId = url.getUserInfo();
        if (credentialId == null || credentialId.indexOf(58) > 0) {
            return new SURL(url, WITHOUT_AUTHENTICATION);
        }
        if (SecurityUtils.existsSecurityCredentials(credentialId)) {
            return new SURL(SURL.removeUserInfo(url), credentialId);
        }
        return new SURL(url, WITHOUT_AUTHENTICATION);
    }

    static SURL createWithoutUser(URL url) throws MalformedURLException {
        return new SURL(SURL.removeUserInfo(url), WITHOUT_AUTHENTICATION);
    }

    static void resetBadHosts() {
        BAD_HOSTS.clear();
    }

    public String toString() {
        return this.internal.toString();
    }

    private boolean isUrlOk() {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.SANDBOX) {
            return false;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.LEGACY) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            return true;
        }
        if (this.isInUrlAllowList()) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.INTERNET) {
            if (this.forbiddenURL(this.cleanPath(this.internal.toString()))) {
                return false;
            }
            int port = this.internal.getPort();
            return port == 80 || port == 443 || port == -1;
        }
        return false;
    }

    private boolean forbiddenURL(String full) {
        if (full.matches("^https?://[.0-9]+/.*")) {
            return true;
        }
        return full.matches("^https?://[^.]+/.*");
    }

    private boolean isInUrlAllowList() {
        String full = this.cleanPath(this.internal.toString());
        for (String allow : this.getUrlAllowList()) {
            if (!full.startsWith(this.cleanPath(allow))) continue;
            return true;
        }
        return false;
    }

    private String cleanPath(String path) {
        path = SURL.removeUserInfoFromUrlPath(path);
        path = path.trim().toLowerCase(Locale.US);
        path = path.replace(":80/", "");
        path = path.replace(":443/", "");
        return path;
    }

    private List<String> getUrlAllowList() {
        String env = SecurityUtils.getenv("plantuml.allowlist.url");
        if (env == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env).split(";"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (!this.isUrlOk()) {
            return null;
        }
        SecurityCredentials credentials = SecurityUtils.loadSecurityCredentials(this.securityIdentifier);
        SecurityAuthentication authentication = SecurityUtils.getAuthenticationManager(credentials).create(credentials);
        try {
            String host = this.internal.getHost();
            Long bad = BAD_HOSTS.get(host);
            if (bad != null) {
                if (System.currentTimeMillis() - bad < 60000L) {
                    byte[] byArray = null;
                    return byArray;
                }
                BAD_HOSTS.remove(host);
            }
            try {
                Future<byte[]> result = EXE.submit(SURL.requestWithGetAndResponse(this.internal, credentials.getProxy(), authentication, null));
                byte[] data = result.get(SecurityUtils.getSecurityProfile().getTimeout(), TimeUnit.MILLISECONDS);
                if (data != null) {
                    byte[] byArray = data;
                    return byArray;
                }
            }
            catch (Exception e) {
                System.err.println("issue " + host + " " + e);
            }
            BAD_HOSTS.put(host, System.currentTimeMillis());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            credentials.eraseCredentials();
            authentication.eraseCredentials();
        }
    }

    private byte[] getBytes(Proxy proxy, SecurityAuthentication authentication, Map<String, Object> headers) {
        if (!this.isUrlOk()) {
            return null;
        }
        Future<byte[]> result = EXE.submit(SURL.requestWithGetAndResponse(this.internal, proxy, authentication, headers));
        try {
            return result.get(SecurityUtils.getSecurityProfile().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("SURL response issue to " + this.internal.getHost() + " " + e);
            return null;
        }
    }

    public byte[] getBytesOnPost(Proxy proxy, SecurityAuthentication authentication, String data, Map<String, Object> headers) {
        if (!this.isUrlOk()) {
            return null;
        }
        Future<byte[]> result = EXE.submit(SURL.requestWithPostAndResponse(this.internal, proxy, authentication, data, headers));
        try {
            return result.get(SecurityUtils.getSecurityProfile().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("SURL response issue to " + this.internal.getHost() + " " + e);
            return null;
        }
    }

    private static Callable<byte[]> requestWithGetAndResponse(final URL url, final Proxy proxy, final SecurityAuthentication authentication, final Map<String, Object> headers) {
        return new Callable<byte[]>(){

            private HttpURLConnection openConnection(URL url2) throws IOException {
                URLConnection connection;
                URLConnection uRLConnection = connection = proxy == null ? url2.openConnection() : url2.openConnection(proxy);
                if (connection == null) {
                    return null;
                }
                HttpURLConnection http = (HttpURLConnection)connection;
                SURL.applyEndpointAccessAuthentication(http, authentication);
                SURL.applyAdditionalHeaders(http, headers);
                return http;
            }

            @Override
            public byte[] call() throws IOException {
                HttpURLConnection http = this.openConnection(url);
                int responseCode = http.getResponseCode();
                if (responseCode == 302 || responseCode == 301) {
                    String newUrl = http.getHeaderField("Location");
                    http = this.openConnection(new URL(newUrl));
                }
                return SURL.retrieveResponseAsBytes(http);
            }
        };
    }

    private static Callable<byte[]> requestWithPostAndResponse(final URL url, final Proxy proxy, final SecurityAuthentication authentication, final String data, final Map<String, Object> headers) {
        return new Callable<byte[]>(){

            @Override
            public byte[] call() throws IOException {
                URLConnection connection;
                URLConnection uRLConnection = connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
                if (connection == null) {
                    return null;
                }
                boolean withContent = StringUtils.isNotEmpty(data);
                HttpURLConnection http = (HttpURLConnection)connection;
                http.setRequestMethod("POST");
                if (withContent) {
                    http.setDoOutput(true);
                }
                SURL.applyEndpointAccessAuthentication(http, authentication);
                SURL.applyAdditionalHeaders(http, headers);
                Charset charSet = SURL.extractCharset(http.getRequestProperty("Content-Type"));
                if (withContent) {
                    SURL.sendRequestAsBytes(http, data.getBytes(charSet != null ? charSet : StandardCharsets.UTF_8));
                }
                return SURL.retrieveResponseAsBytes(http);
            }
        };
    }

    private static Charset extractCharset(String contentType) {
        if (StringUtils.isEmpty(contentType)) {
            return null;
        }
        Matcher matcher = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)").matcher(contentType);
        if (matcher.find()) {
            try {
                return Charset.forName(matcher.group(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static byte[] retrieveResponseAsBytes(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode < 400) {
            try (InputStream input = connection.getInputStream();){
                byte[] byArray = SURL.retrieveData(input);
                return byArray;
            }
        }
        InputStream error = connection.getErrorStream();
        try {
            byte[] bytes = SURL.retrieveData(error);
            throw new IOException("HTTP error " + responseCode + " with " + new String(bytes, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            if (error != null) {
                try {
                    error.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private static byte[] retrieveData(InputStream input) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = input.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        out.close();
        return out.toByteArray();
    }

    private static void sendRequestAsBytes(HttpURLConnection connection, byte[] data) throws IOException {
        connection.setFixedLengthStreamingMode(data.length);
        try (OutputStream os = connection.getOutputStream();){
            os.write(data);
        }
    }

    public InputStream openStream() {
        byte[] data;
        if (this.isUrlOk() && (data = this.getBytes()) != null) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    public BufferedImage readRasterImageFromURL() {
        if (this.isUrlOk()) {
            try {
                byte[] bytes = this.getBytes();
                if (bytes == null || bytes.length == 0) {
                    return null;
                }
                ImageIcon tmp = new ImageIcon(bytes);
                return SecurityUtils.readRasterImage(tmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isAuthorizationConfigured() {
        return !WITHOUT_AUTHENTICATION.equals(this.securityIdentifier);
    }

    private static void applyEndpointAccessAuthentication(URLConnection http, SecurityAuthentication authentication) {
        if (authentication.isPublic()) {
            return;
        }
        if (!(http instanceof HttpsURLConnection) && !SecurityUtils.isNonSSLAuthenticationAllowed()) {
            throw new IllegalStateException("The transport of authentication data over an unencrypted http connection is not allowed");
        }
        SecurityAccessInterceptor accessInterceptor = SecurityUtils.getAccessInterceptor(authentication);
        accessInterceptor.apply(authentication, http);
    }

    private static void applyAdditionalHeaders(URLConnection http, Map<String, Object> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            Object value = header.getValue();
            if (value instanceof String) {
                http.setRequestProperty(header.getKey(), (String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object item : (List)value) {
                if (item == null) continue;
                http.addRequestProperty(header.getKey(), item.toString());
            }
        }
    }

    private static URL removeUserInfo(URL url) throws MalformedURLException {
        return new URL(SURL.removeUserInfoFromUrlPath(url.toExternalForm()));
    }

    private static String removeUserInfoFromUrlPath(String url) {
        Matcher matcher = PATTERN_USERINFO.matcher(url);
        if (matcher.find()) {
            return matcher.replaceFirst("$1$3");
        }
        return url;
    }
}

