/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Notes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class NotesTile
extends AbstractTile
implements Tile {
    private final LivingSpaces livingSpaces;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Notes notes;

    @Override
    public Event getEvent() {
        return this.notes;
    }

    public NotesTile(StringBounder stringBounder, LivingSpaces livingSpaces, Notes notes, Rose skin, ISkinParam skinParam) {
        super(stringBounder);
        this.livingSpaces = livingSpaces;
        this.notes = notes;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    private Component getComponent(StringBounder stringBounder, Note note) {
        Component comp = this.skin.createComponentNote(note.getUsedStyles(), this.getNoteComponentType(note.getNoteStyle()), note.getSkinParamBackcolored(this.skinParam), note.getStrings(), note.getPosition());
        return comp;
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Note note : this.notes) {
            Component comp = this.getComponent(stringBounder, note);
            Dimension2D dim = comp.getPreferredDimension(stringBounder);
            double x = this.getX(stringBounder, note).getCurrentValue();
            Area area = Area.create(this.getUsedWidth(stringBounder, note), dim.getHeight());
            UGraphic ug2 = ug.apply(UTranslate.dx(x));
            comp.drawU(ug2, area, (Context2D)((Object)ug2));
        }
    }

    private double getUsedWidth(StringBounder stringBounder, Note note) {
        Component comp = this.getComponent(stringBounder, note);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        return width;
    }

    private Real getXcenter(StringBounder stringBounder, Note note) {
        LivingSpace livingSpace1 = this.livingSpaces.get(note.getParticipant());
        return livingSpace1.getPosC(stringBounder);
    }

    private Real getX(StringBounder stringBounder, Note note) {
        LivingSpace livingSpace1 = this.livingSpaces.get(note.getParticipant());
        NotePosition position = note.getPosition();
        double width = this.getUsedWidth(stringBounder, note);
        if (position == NotePosition.LEFT) {
            return livingSpace1.getPosC(stringBounder).addFixed(-width);
        }
        if (position == NotePosition.RIGHT) {
            int level = livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            double dx = (double)level * 5.0;
            return livingSpace1.getPosC(stringBounder).addFixed(dx);
        }
        if (position == NotePosition.OVER_SEVERAL) {
            LivingSpace livingSpace2 = this.livingSpaces.get(note.getParticipant2());
            Real x1 = livingSpace1.getPosC(stringBounder);
            Real x2 = livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(x1, x2).addFixed(-width / 2.0);
        }
        if (position == NotePosition.OVER) {
            return livingSpace1.getPosC(stringBounder).addFixed(-width / 2.0);
        }
        throw new UnsupportedOperationException(position.toString());
    }

    @Override
    public double getPreferredHeight() {
        double result = 0.0;
        for (Note note : this.notes) {
            Component comp = this.getComponent(this.getStringBounder(), note);
            Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
            result = Math.max(result, dim.getHeight());
        }
        return result;
    }

    @Override
    public void addConstraints() {
        List<Note> all = this.notes.asList();
        for (int i = 0; i < all.size() - 1; ++i) {
            for (int j = i + 1; j < all.size(); ++j) {
                double center1 = this.getXcenter(this.getStringBounder(), all.get(i)).getCurrentValue();
                double center2 = this.getXcenter(this.getStringBounder(), all.get(j)).getCurrentValue();
                if (center2 > center1) {
                    Real point1b = this.getX2(this.getStringBounder(), all.get(i));
                    Real point2 = this.getX(this.getStringBounder(), all.get(j));
                    point2.ensureBiggerThan(point1b);
                    continue;
                }
                Real point1 = this.getX(this.getStringBounder(), all.get(i));
                Real point2b = this.getX2(this.getStringBounder(), all.get(j));
                point1.ensureBiggerThan(point2b);
            }
        }
    }

    @Override
    public Real getMinX() {
        ArrayList<Real> reals = new ArrayList<Real>();
        for (Note note : this.notes) {
            reals.add(this.getX(this.getStringBounder(), note));
        }
        return RealUtils.min(reals);
    }

    private Real getX2(StringBounder stringBounder, Note note) {
        return this.getX(stringBounder, note).addFixed(this.getUsedWidth(stringBounder, note));
    }

    @Override
    public Real getMaxX() {
        ArrayList<Real> reals = new ArrayList<Real>();
        for (Note note : this.notes) {
            reals.add(this.getX2(this.getStringBounder(), note));
        }
        return RealUtils.max(reals);
    }
}

