/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.util.Arrays;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class ChangeState
implements Comparable<ChangeState> {
    private final TimeTick when;
    private final String[] states;
    private final String comment;
    private final Colors colors;

    public ChangeState(TimeTick when, String comment, Colors colors, String ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException();
        }
        this.when = when;
        this.states = states;
        this.comment = comment;
        this.colors = colors;
    }

    @Override
    public int compareTo(ChangeState other) {
        return this.when.compareTo(other.when);
    }

    public final TimeTick getWhen() {
        return this.when;
    }

    public final String getState() {
        return this.states[0];
    }

    public final List<String> getStates() {
        return Arrays.asList(this.states);
    }

    public String getComment() {
        return this.comment;
    }

    public final HColor getBackColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.BACK) == null) {
            return style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.BACK);
    }

    private final HColor getLineColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.LINE) == null) {
            return style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.LINE);
    }

    private UStroke getStroke(Style style) {
        return style.getStroke();
    }

    public SymbolContext getContext(ISkinParam skinParam, Style style) {
        return new SymbolContext(this.getBackColor(skinParam, style), this.getLineColor(skinParam, style)).withStroke(this.getStroke(style));
    }

    public final boolean isBlank() {
        return this.states[0].equals("{...}");
    }

    public final boolean isCompletelyHidden() {
        return this.states[0].equals("{hidden}");
    }

    public final boolean isFlat() {
        return this.states[0].equals("{-}");
    }
}

