/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import java.math.BigDecimal;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Clocks;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingFormat;

public class TimeTickBuilder {
    public static IRegex expressionAtWithoutArobase(String name) {
        return new RegexOr(new RegexLeaf(name + "CODE", ":([%pLN_.]+)([-+]\\d+)?"), new RegexLeaf(name + "DATE", "(\\d+)/(\\d+)/(\\d+)"), new RegexLeaf(name + "HOUR", "(\\d+):(\\d+):(\\d+)"), new RegexLeaf(name + "DIGIT", "(\\+?)(-?\\d+\\.?\\d*)"), new RegexLeaf(name + "CLOCK", "([%pLN_.@]+)\\*(\\d+)"));
    }

    public static IRegex expressionAtWithArobase(String name) {
        return new RegexConcat(new RegexLeaf("@"), TimeTickBuilder.expressionAtWithoutArobase(name));
    }

    public static IRegex optionalExpressionAtWithArobase(String name) {
        return new RegexOptional(TimeTickBuilder.expressionAtWithArobase(name));
    }

    public static TimeTick parseTimeTick(String name, RegexResult arg, Clocks clock) {
        String code = arg.get(name + "CODE", 0);
        if (code != null) {
            String delta = arg.get(name + "CODE", 1);
            TimeTick result = clock.getCodeValue(code);
            if (delta == null) {
                return result;
            }
            BigDecimal value = result.getTime().add(new BigDecimal(delta));
            return new TimeTick(value, TimingFormat.DECIMAL);
        }
        String clockName = arg.get(name + "CLOCK", 0);
        if (clockName != null) {
            int number = Integer.parseInt(arg.get(name + "CLOCK", 1));
            return clock.getClockValue(clockName, number);
        }
        String hour = arg.get(name + "HOUR", 0);
        if (hour != null) {
            int h2 = Integer.parseInt(arg.get(name + "HOUR", 0));
            int m3 = Integer.parseInt(arg.get(name + "HOUR", 1));
            int s2 = Integer.parseInt(arg.get(name + "HOUR", 2));
            BigDecimal value = new BigDecimal(3600 * h2 + 60 * m3 + s2);
            return new TimeTick(value, TimingFormat.HOUR);
        }
        String date = arg.get(name + "DATE", 0);
        if (date != null) {
            int yy = Integer.parseInt(arg.get(name + "DATE", 0));
            int mm3 = Integer.parseInt(arg.get(name + "DATE", 1));
            int dd = Integer.parseInt(arg.get(name + "DATE", 2));
            return TimingFormat.createDate(yy, mm3, dd, clock.getTimingFormatDate());
        }
        String number = arg.get(name + "DIGIT", 1);
        if (number == null) {
            return clock.getNow();
        }
        boolean isRelative = "+".equals(arg.get(name + "DIGIT", 0));
        BigDecimal value = new BigDecimal(number);
        if (isRelative && clock.getNow() != null) {
            value = clock.getNow().getTime().add(value);
        }
        return new TimeTick(value, TimingFormat.DECIMAL);
    }
}

