/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.graphic;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class PlayerFrame {
    private final ISkinParam skinParam;
    private final TextBlock title;

    public PlayerFrame(TextBlock title, ISkinParam skinParam) {
        this.title = title;
        this.skinParam = skinParam;
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram);
    }

    private HColor getLineColor() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
    }

    private UStroke getUStroke() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.getStroke();
    }

    public void drawFrameTitle(UGraphic ug) {
        this.title.drawU(ug);
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        ug = ug.apply(this.getLineColor()).apply(this.getUStroke());
        double widthTmp = dimTitle.getWidth() + 1.0;
        double height = this.title.calculateDimension(ug.getStringBounder()).getHeight() + 1.0;
        this.drawLine(ug, -5.0, height, widthTmp, height, widthTmp + 10.0, 0.0);
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }
}

