/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;

public class DriverEllipseSvg
implements UDriver<UEllipse, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverEllipseSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UEllipse shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        double width = shape.getWidth();
        double height = shape.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + width, y + height)) {
                return;
            }
        }
        DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
        DriverRectangleSvg.applyFillColor(svg, mapper, param);
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        double start = shape.getStart();
        double extend = shape.getExtend();
        double cx = x + width / 2.0;
        double cy = y + height / 2.0;
        if (start == 0.0 && extend == 0.0) {
            svg.svgEllipse(cx, cy, width / 2.0, height / 2.0, shape.getDeltaShadow());
        } else {
            start += 90.0;
            if (extend > 0.0) {
                double x1 = cx + Math.sin(start * Math.PI / 180.0) * width / 2.0;
                double y1 = cy + Math.cos(start * Math.PI / 180.0) * height / 2.0;
                double x2 = cx + Math.sin((start + extend) * Math.PI / 180.0) * width / 2.0;
                double y2 = cy + Math.cos((start + extend) * Math.PI / 180.0) * height / 2.0;
                svg.svgArcEllipse(width / 2.0, height / 2.0, x1, y1, x2, y2);
            } else {
                double x1 = cx + Math.sin((start + extend) * Math.PI / 180.0) * width / 2.0;
                double y1 = cy + Math.cos((start + extend) * Math.PI / 180.0) * height / 2.0;
                double x2 = cx + Math.sin(start * Math.PI / 180.0) * width / 2.0;
                double y2 = cy + Math.cos(start * Math.PI / 180.0) * height / 2.0;
                svg.svgArcEllipse(width / 2.0, height / 2.0, x1, y1, x2, y2);
            }
        }
    }
}

