/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wire;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.wire.WArrowDirection;
import znaishaded.net.sourceforge.plantuml.wire.WLinkType;
import znaishaded.net.sourceforge.plantuml.wire.WOrientation;
import znaishaded.net.sourceforge.plantuml.wire.WireDiagram;

public class CommandWLink
extends SingleLineCommand2<WireDiagram> {
    public CommandWLink() {
        super(false, CommandWLink.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWLink.class.getName(), RegexLeaf.start(), new RegexLeaf("NAME1", "([\\w][.\\w]*)"), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("\\("), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("X1", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("Y1", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(\\<?[-=]{1,2}\\>|\\<?[-=]{1,2})"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NAME2", "([\\w][.\\w]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#\\w+)?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WireDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Display label;
        String name1 = arg.get("NAME1", 0);
        String x1 = arg.get("X1", 0);
        String y1 = arg.get("Y1", 0);
        String name2 = arg.get("NAME2", 0);
        String style = arg.get("STYLE", 0);
        WLinkType type = WLinkType.from(style);
        WArrowDirection direction = WArrowDirection.from(style);
        WOrientation orientation = WOrientation.from(style);
        String stringColor = arg.get("COLOR", 0);
        HColor color = null;
        if (stringColor != null) {
            color = HColorSet.instance().getColor(diagram.getSkinParam().getThemeStyle(), stringColor);
        }
        if (arg.get("MESSAGE", 0) == null) {
            label = Display.NULL;
        } else {
            String message = arg.get("MESSAGE", 0);
            label = Display.getWithNewlines(message);
        }
        if (orientation == WOrientation.VERTICAL) {
            return diagram.vlink(name1, x1, y1, name2, type, direction, color, label);
        }
        return diagram.hlink(name1, x1, y1, name2, type, direction, color, label);
    }
}

