/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.types.resources.selectors;

import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.types.RegularExpression;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import znaishaded.org.apache.tools.ant.types.selectors.SelectorUtils;
import znaishaded.org.apache.tools.ant.util.regexp.Regexp;
import znaishaded.org.apache.tools.ant.util.regexp.RegexpUtil;

public class Name
implements ResourceSelector {
    private String regex = null;
    private String pattern;
    private boolean cs = true;
    private boolean handleDirSep = false;
    private RegularExpression reg;
    private Regexp expression;
    private Project project;

    public void setProject(Project p) {
        this.project = p;
    }

    public void setName(String n) {
        this.pattern = n;
    }

    public String getName() {
        return this.pattern;
    }

    public void setRegex(String r) {
        this.regex = r;
        this.reg = null;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setCaseSensitive(boolean b) {
        this.cs = b;
    }

    public boolean isCaseSensitive() {
        return this.cs;
    }

    public void setHandleDirSep(boolean handleDirSep) {
        this.handleDirSep = handleDirSep;
    }

    public boolean doesHandledirSep() {
        return this.handleDirSep;
    }

    @Override
    public boolean isSelected(Resource r) {
        String n = r.getName();
        if (this.matches(n)) {
            return true;
        }
        String s2 = r.toString();
        return !s2.equals(n) && this.matches(s2);
    }

    private boolean matches(String name) {
        if (this.pattern != null) {
            return SelectorUtils.match(this.modify(this.pattern), this.modify(name), this.cs);
        }
        if (this.reg == null) {
            this.reg = new RegularExpression();
            this.reg.setPattern(this.regex);
            this.expression = this.reg.getRegexp(this.project);
        }
        return this.expression.matches(this.modify(name), RegexpUtil.asOptions(this.cs));
    }

    private String modify(String s2) {
        if (s2 == null || !this.handleDirSep || !s2.contains("\\")) {
            return s2;
        }
        return s2.replace('\\', '/');
    }
}

