/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescriptionParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenTextWithLinksParser;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;

public class DoxygenMemberParser {
    private final ComponentsRegistry componentsRegistry;
    private final Node memberNode;
    private final DoxygenMember member;

    private DoxygenMemberParser(ComponentsRegistry componentsRegistry, Node memberNode) {
        this.componentsRegistry = componentsRegistry;
        this.memberNode = memberNode;
        this.member = new DoxygenMember();
    }

    public static DoxygenMember parse(ComponentsRegistry componentsRegistry, Node memberNode) {
        DoxygenMemberParser parser = new DoxygenMemberParser(componentsRegistry, memberNode);
        parser.parseXml();
        return parser.member;
    }

    private void parseXml() {
        this.parseMember(this.memberNode);
    }

    private void parseMember(Node memberNode) {
        this.member.setId(XmlUtils.getAttributeText(memberNode, "id"));
        this.member.setName(XmlUtils.nextLevelNodeByName(memberNode, "name").getTextContent());
        this.member.setKind(XmlUtils.getAttributeText(memberNode, "kind"));
        this.member.setVisibility(XmlUtils.getAttributeText(memberNode, "prot"));
        this.member.setStatic("yes".equals(XmlUtils.getAttributeText(memberNode, "static")));
        this.member.setVirtual("virtual".equals(XmlUtils.getAttributeText(memberNode, "virt")));
        this.member.setConst("yes".equals(XmlUtils.getAttributeText(memberNode, "const")));
        this.member.setNoExcept("yes".equals(XmlUtils.getAttributeText(memberNode, "noexcept")));
        this.member.setDeclType(this.extractDeclType(XmlUtils.nextLevelNodeByName(memberNode, "argsstring").getTextContent()));
        DocStructure docStructure = this.componentsRegistry.docStructure();
        this.member.setReturnType(DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName(memberNode, "type")));
        XmlUtils.childrenNodesStreamByName(memberNode, "param").forEach(paramNode -> {
            String name = XmlUtils.nextLevelNodeByName(paramNode, "declname").getTextContent();
            ApiLinkedText type = DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName(paramNode, "type"));
            this.member.addParameter(name, type);
        });
        this.member.buildNormalizedParamsSignature();
        if (XmlUtils.hasNodeByName(memberNode, "templateparamlist")) {
            Node templateParamsNode = XmlUtils.nextLevelNodeByName(memberNode, "templateparamlist");
            XmlUtils.childrenNodesStreamByName(templateParamsNode, "param").forEach(paramNode -> {
                ApiLinkedText type = DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName(paramNode, "type"));
                this.member.addTemplateParameter("", type);
            });
        }
        this.member.setDescription(new DoxygenDescription(DoxygenDescriptionParser.parseBrief(this.componentsRegistry, XmlUtils.anyNestedNodeByName(memberNode, "briefdescription")), DoxygenDescriptionParser.parseFull(this.componentsRegistry, this.member.getParameters(), this.member.getName(), XmlUtils.anyNestedNodeByName(memberNode, "detaileddescription"))));
    }

    private String extractDeclType(String args) {
        int idx = args.indexOf("decltype(");
        if (idx == -1) {
            return "";
        }
        return args.substring(idx).trim();
    }
}

