/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.sphinx.python;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunction;

public class PythonClass {
    private String refId;
    private String name;
    private String description;
    private List<PythonFunction> methods;

    public PythonClass(String refId, String name, String description) {
        this.refId = refId;
        this.name = name;
        this.description = description;
        this.methods = new ArrayList<PythonFunction>();
    }

    public void addMethod(PythonFunction method) {
        this.methods.add(method);
    }

    public String getRefId() {
        return this.refId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PythonFunction> getMethods() {
        return this.methods;
    }

    public String toString() {
        return "PythonClass{refId='" + this.refId + "', name='" + this.name + "', description='" + this.description + "', methods=" + this.methods + "}";
    }

    public Map<String, ?> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("refId", this.refId);
        result.put("name", this.name);
        result.put("description", this.description);
        result.put("methods", this.methods.stream().map(PythonFunction::toMap).collect(Collectors.toList()));
        return result;
    }
}

