/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.report;

import java.util.ArrayList;
import java.util.Iterator;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.LogLevel;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.google.common.collect.ImmutableSet;
import znaishaded.com.google.common.collect.Lists;

public abstract class AbstractProcessingReport
implements ProcessingReport {
    private LogLevel currentLevel = LogLevel.DEBUG;
    private final LogLevel logLevel;
    private final LogLevel exceptionThreshold;

    protected AbstractProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        this.logLevel = logLevel;
        this.exceptionThreshold = exceptionThreshold;
    }

    protected AbstractProcessingReport(LogLevel logLevel) {
        this(logLevel, LogLevel.FATAL);
    }

    protected AbstractProcessingReport() {
        this(LogLevel.INFO, LogLevel.FATAL);
    }

    @Override
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public final LogLevel getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    @Override
    public final void debug(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.DEBUG));
    }

    @Override
    public final void info(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.INFO));
    }

    @Override
    public final void warn(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.WARNING));
    }

    @Override
    public final void error(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.ERROR));
    }

    @Override
    public final void fatal(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.FATAL));
    }

    @Override
    public final boolean isSuccess() {
        return this.currentLevel.compareTo(LogLevel.ERROR) < 0;
    }

    public abstract void log(LogLevel var1, ProcessingMessage var2);

    protected final void dispatch(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo(this.exceptionThreshold) >= 0) {
            throw message.asException();
        }
        if (level.compareTo(this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo(this.logLevel) >= 0) {
            this.log(level, message);
        }
    }

    @Override
    public Iterator<ProcessingMessage> iterator() {
        return ImmutableSet.of().iterator();
    }

    @Override
    public final void mergeWith(ProcessingReport other) throws ProcessingException {
        if (!other.isSuccess() && this.currentLevel.compareTo(LogLevel.ERROR) < 0) {
            this.currentLevel = LogLevel.ERROR;
        }
        for (ProcessingMessage message : other) {
            this.dispatch(message);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getCanonicalName()).append(": ").append(this.isSuccess() ? "success" : "failure").append('\n');
        ArrayList<ProcessingMessage> messages = Lists.newArrayList(this);
        if (!messages.isEmpty()) {
            sb.append("--- BEGIN MESSAGES ---\n");
            for (ProcessingMessage message : messages) {
                sb.append(message);
            }
            sb.append("---  END MESSAGES  ---\n");
        }
        return sb.toString();
    }
}

