/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.main.cli;

import java.io.IOException;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import znaishaded.com.github.fge.jsonschema.main.JsonSchema;
import znaishaded.com.github.fge.jsonschema.main.cli.Reporter;
import znaishaded.com.github.fge.jsonschema.main.cli.RetCode;
import znaishaded.com.github.fge.jsonschema.processors.syntax.SyntaxValidator;

enum Reporters implements Reporter
{
    DEFAULT{

        @Override
        public RetCode validateSchema(SyntaxValidator validator, String fileName, JsonNode node) throws IOException {
            ListProcessingReport report = (ListProcessingReport)validator.validateSchema(node);
            boolean success = report.isSuccess();
            System.out.println("--- BEGIN " + fileName + "---");
            System.out.println("validation: " + (success ? "SUCCESS" : "FAILURE"));
            if (!success) {
                System.out.println(JacksonUtils.prettyPrint(report.asJson()));
            }
            System.out.println("--- END " + fileName + "---");
            return success ? RetCode.ALL_OK : RetCode.SCHEMA_SYNTAX_ERROR;
        }

        @Override
        public RetCode validateInstance(JsonSchema schema, String fileName, JsonNode node) throws IOException, ProcessingException {
            ListProcessingReport report = (ListProcessingReport)schema.validate(node, true);
            boolean success = report.isSuccess();
            System.out.println("--- BEGIN " + fileName + "---");
            System.out.println("validation: " + (success ? "SUCCESS" : "FAILURE"));
            if (!success) {
                System.out.println(JacksonUtils.prettyPrint(report.asJson()));
            }
            System.out.println("--- END " + fileName + "---");
            return success ? RetCode.ALL_OK : RetCode.VALIDATION_FAILURE;
        }
    }
    ,
    BRIEF{

        @Override
        public RetCode validateSchema(SyntaxValidator validator, String fileName, JsonNode node) throws IOException {
            boolean valid = validator.schemaIsValid(node);
            System.out.printf("%s: %s\n", fileName, valid ? "OK" : "NOT OK");
            return valid ? RetCode.ALL_OK : RetCode.SCHEMA_SYNTAX_ERROR;
        }

        @Override
        public RetCode validateInstance(JsonSchema schema, String fileName, JsonNode node) throws IOException, ProcessingException {
            boolean valid = schema.validInstance(node);
            System.out.printf("%s: %s\n", fileName, valid ? "OK" : "NOT OK");
            return valid ? RetCode.ALL_OK : RetCode.VALIDATION_FAILURE;
        }
    }
    ,
    QUIET{

        @Override
        public RetCode validateSchema(SyntaxValidator validator, String fileName, JsonNode node) throws IOException {
            return validator.schemaIsValid(node) ? RetCode.ALL_OK : RetCode.SCHEMA_SYNTAX_ERROR;
        }

        @Override
        public RetCode validateInstance(JsonSchema schema, String fileName, JsonNode node) throws IOException, ProcessingException {
            return schema.validInstance(node) ? RetCode.ALL_OK : RetCode.VALIDATION_FAILURE;
        }
    };

}

