/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.abel;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityGender;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;

public class EntityGenderUtils {
    public static EntityGender byEntityType(final LeafType type) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return test2.getLeafType() == type;
            }
        };
    }

    public static EntityGender byEntityAlone(final Entity entity) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return test2.getUid().equals(entity.getUid());
            }
        };
    }

    public static EntityGender byStereotype(final String stereotype) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                if (test2.getStereotype() == null) {
                    return false;
                }
                return stereotype.equals(test2.getStereotype().getLabel(Guillemet.DOUBLE_COMPARATOR));
            }
        };
    }

    public static EntityGender byPackage(final Entity group) {
        if (group.isRoot()) {
            throw new IllegalArgumentException();
        }
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                if (test2.getParentContainer().isRoot()) {
                    return false;
                }
                return group == test2.getParentContainer();
            }
        };
    }

    public static EntityGender and(final EntityGender g1, final EntityGender g2) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return g1.contains(test2) && g2.contains(test2);
            }
        };
    }

    public static EntityGender all() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return true;
            }
        };
    }

    public static EntityGender emptyMethods() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return test2.getBodier().getMethodsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyFields() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test2) {
                return test2.getBodier().getFieldsToDisplay().size() == 0;
            }
        };
    }
}

