/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileEmpty;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class GPoint {
    public static final String NORTH_HOOK = "NORTH_HOOK";
    public static final String SOUTH_HOOK = "SOUTH_HOOK";
    public static final String WEST_HOOK = "WEST_HOOK";
    public static final String EAST_HOOK = "EAST_HOOK";
    public static final String NORTH_BORDER = "NORTH_BORDER";
    public static final String SOUTH_BORDER = "SOUTH_BORDER";
    public static final String WEST_BORDER = "WEST_BORDER";
    public static final String EAST_BORDER = "EAST_BORDER";
    private final Gtile gtile;
    private final String name;
    private final LinkRendering linkRendering;

    public GPoint(Gtile gtile, String name, LinkRendering linkRendering) {
        if (gtile instanceof GtileEmpty) {
            System.err.println("Warning 1");
        }
        this.gtile = gtile;
        this.name = name;
        this.linkRendering = linkRendering;
    }

    public GPoint(Gtile gtile, String name) {
        this(gtile, name, LinkRendering.none());
    }

    public String toString() {
        return this.gtile + "@" + this.name;
    }

    public Gtile getGtile() {
        return this.gtile;
    }

    public String getName() {
        return this.name;
    }

    public UTranslate getCoord() {
        return this.gtile.getCoord(this.name);
    }

    public XPoint2D getPoint2D() {
        return this.getCoord().getPosition();
    }

    public LinkRendering getLinkRendering() {
        return this.linkRendering;
    }

    public boolean match(Swimlane swimlane) {
        Swimlane tmp = this.gtile.getSwimlane(this.name);
        return tmp == swimlane;
    }

    public Swimlane getSwimlane() {
        Swimlane result = this.gtile.getSwimlane(this.name);
        if (result == null) {
            throw new IllegalStateException(this.name + " " + this.gtile.getClass().toString() + " " + this.gtile);
        }
        return result;
    }
}

