/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.klimt.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.skin.SkinParamColors;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GtileBox
extends AbstractGtile {
    private final ClockwiseTopRightBottomLeft padding;
    private final ClockwiseTopRightBottomLeft margin;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    public static GtileBox create(StringBounder stringBounder, ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Stereotype stereotype) {
        Style style = GtileBox.getDefaultStyleDefinitionActivity().withTOBECHANGED(stereotype).getMergedStyle(skinParam.getCurrentStyleBuilder());
        Style styleArrow = GtileBox.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new GtileBox(stringBounder, skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    private GtileBox(StringBounder stringBounder, ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(stringBounder, skinParam, swimlane);
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        this.style = style = style.eventuallyOverride(specBack);
        this.boxStyle = boxStyle;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet()));
        this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.padding = style.getPadding();
        this.margin = style.getMargin();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = skinParam.sheet(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), UStroke.withThickness(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(HColors.none()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(HColors.none().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            XDimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimTb.getWidth() - this.padding.getRight(), this.padding.getBottom())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            XDimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((dimTotal.getWidth() - dimTb.getWidth()) / 2.0, this.padding.getBottom())));
        }
    }

    @Override
    public final XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = dimRaw.delta(this.padding.getLeft() + this.padding.getRight(), this.padding.getBottom() + this.padding.getTop());
        dimRaw = dimRaw.atLeast(this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -GtileBox.this.padding.getLeft();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            XDimension2D dim = GtileBox.this.calculateDimension(stringBounder);
            return dim.getWidth() - GtileBox.this.padding.getRight();
        }
    }
}

