/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.List;
import znaishaded.net.atmp.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.abel.LinkArg;
import znaishaded.net.sourceforge.plantuml.cucadiagram.SquareLinker;
import znaishaded.net.sourceforge.plantuml.cucadiagram.SquareMaker;
import znaishaded.net.sourceforge.plantuml.decoration.LinkDecor;
import znaishaded.net.sourceforge.plantuml.decoration.LinkType;

public class Magma {
    private final CucaDiagram diagram;
    private final List<Entity> standalones;
    private final LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();

    public Magma(CucaDiagram system, List<Entity> standalones) {
        this.diagram = system;
        this.standalones = standalones;
    }

    public void putInSquare() {
        SquareLinker<Entity> linker = new SquareLinker<Entity>(){

            @Override
            public void topDown(Entity top, Entity down) {
                Magma.this.diagram.addLink(new Link(Magma.this.diagram.getEntityFactory(), Magma.this.diagram.getSkinParam().getCurrentStyleBuilder(), top, down, Magma.this.linkType, LinkArg.noDisplay(2)));
            }

            @Override
            public void leftRight(Entity left, Entity right) {
                Magma.this.diagram.addLink(new Link(Magma.this.diagram.getEntityFactory(), Magma.this.diagram.getSkinParam().getCurrentStyleBuilder(), left, right, Magma.this.linkType, LinkArg.noDisplay(1)));
            }
        };
        new SquareMaker<Entity>().putInSquare(this.standalones, linker);
    }

    public Entity getContainer() {
        Entity parent = this.standalones.get(0).getParentContainer();
        if (parent == null) {
            return null;
        }
        return parent.getParentContainer();
    }

    public boolean isComplete() {
        Entity parent = this.getContainer();
        if (parent == null) {
            return false;
        }
        return parent.countChildren() == this.standalones.size();
    }

    private int squareSize() {
        return SquareMaker.computeBranch(this.standalones.size());
    }

    private Entity getTopLeft() {
        return this.standalones.get(0);
    }

    private Entity getBottomLeft() {
        int result = SquareMaker.getBottomLeft(this.standalones.size());
        return this.standalones.get(result);
    }

    private Entity getTopRight() {
        int s2 = this.squareSize();
        return this.standalones.get(s2 - 1);
    }

    public String toString() {
        return this.standalones.get(0).getParentContainer() + " " + this.standalones.toString() + " " + this.isComplete();
    }

    public void linkToDown(Magma down) {
        this.diagram.addLink(new Link(this.diagram.getEntityFactory(), this.diagram.getSkinParam().getCurrentStyleBuilder(), this.getBottomLeft(), down.getTopLeft(), this.linkType, LinkArg.noDisplay(2)));
    }

    public void linkToRight(Magma right) {
        this.diagram.addLink(new Link(this.diagram.getEntityFactory(), this.diagram.getSkinParam().getCurrentStyleBuilder(), this.getTopRight(), right.getTopLeft(), this.linkType, LinkArg.noDisplay(1)));
    }
}

