/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dedication;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import znaishaded.net.sourceforge.plantuml.dedication.BlumBlumShub;
import znaishaded.net.sourceforge.plantuml.dedication.Dedication;
import znaishaded.net.sourceforge.plantuml.dedication.Noise;
import znaishaded.net.sourceforge.plantuml.dedication.RBlocks;
import znaishaded.net.sourceforge.plantuml.dedication.TinyHashableString;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.utils.MTRandom;

public class DedicationCrypted
implements Dedication {
    private final String argon2;
    private final BigInteger pq;
    private final byte[] crypted;
    private final int tinyHash;
    private String solution;
    private long next = 0L;

    public DedicationCrypted(byte[] crypted, int tinyHash, String argon2, BigInteger pq) {
        this.crypted = crypted;
        this.pq = pq;
        this.argon2 = argon2;
        this.tinyHash = tinyHash;
    }

    @Override
    public synchronized BufferedImage getImage(TinyHashableString sentence) {
        String line = sentence.getSentence();
        if (line.length() < 40) {
            return null;
        }
        try {
            if (this.solution == null || !line.equals(this.solution)) {
                if (System.currentTimeMillis() < this.next) {
                    return null;
                }
                if (this.tinyHash != sentence.tinyHash()) {
                    return null;
                }
                this.next = System.currentTimeMillis() + 5000L;
            }
            byte[] hash1 = Noise.computeArgon2bytes(line.getBytes(StandardCharsets.UTF_8), (this.pq.toString(35) + line).getBytes(StandardCharsets.UTF_8));
            byte[] hash2 = Noise.computeArgon2bytes(line.getBytes(StandardCharsets.UTF_8), (this.pq.toString(36) + line).getBytes(StandardCharsets.UTF_8));
            BlumBlumShub rndBBS = new BlumBlumShub(this.pq, hash1);
            MTRandom rndMT = new MTRandom(hash2);
            byte[] current = (byte[])this.crypted.clone();
            Noise.shuffle(current, rndMT);
            Noise.xor(current, rndBBS);
            Noise.xor(current, line.getBytes(StandardCharsets.UTF_8));
            Noise.shuffle(current, rndMT);
            RBlocks init = RBlocks.readFrom(current, 513);
            RBlocks decoded = init.change(E, N);
            current = decoded.toByteArray(512);
            Noise.shuffle(current, rndMT);
            Noise.xor(current, rndBBS);
            String argon = Noise.computeArgon2String(current, (this.pq.toString(34) + line).getBytes(StandardCharsets.UTF_8));
            if (!this.argon2.equals(argon)) {
                return null;
            }
            Noise.shuffle(current, rndMT);
            current = Noise.reverse(current, rndMT.nextInt());
            BufferedImage img = SFile.getBufferedImageFromWebpButHeader(new ByteArrayInputStream(current));
            this.solution = line;
            return img;
        }
        catch (Throwable t) {
            Logme.error(t);
            return null;
        }
    }
}

