/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;

public class CommandCreoleUrl
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(" + UrlBuilder.getRegexp() + ")");

    @Override
    public String startingChars() {
        return "[";
    }

    public static Command create() {
        return new CommandCreoleUrl();
    }

    private CommandCreoleUrl() {
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        UrlBuilder urlBuilder = new UrlBuilder(stripe.getSkinParam().getValue("topurl"), UrlMode.STRICT);
        Url url = urlBuilder.getUrl(m3.group(1));
        stripe.addUrl(url);
        return line.substring(m3.group(1).length());
    }
}

