/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.svg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.TransformerException;
import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UGroupType;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverCenteredCharacterSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverDotPathSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverEllipseSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverImagePng;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverImageSvgSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverLineSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverPathSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverPixelSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverPolygonSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverRectangleSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverTextAsPathSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.DriverTextSvg;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.SvgOption;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.shape.DotPath;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UComment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImageSvg;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPixel;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer {
    private final boolean textAsPath;
    private SvgOption option;

    @Override
    public double dpiFactor() {
        return 1.0;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicSvg result = new UGraphicSvg(this.getStringBounder(), this.textAsPath);
        result.copy(this);
        result.option = this.option;
        return result;
    }

    private UGraphicSvg(StringBounder stringBounder, boolean textAsPath) {
        super(stringBounder);
        this.textAsPath = textAsPath;
        this.register();
    }

    public static UGraphicSvg build(SvgOption option, boolean textAsPath, long seed, StringBounder stringBounder) {
        UGraphicSvg result = new UGraphicSvg(stringBounder, textAsPath);
        result.copy(option.getBackcolor(), option.getColorMapper(), new SvgGraphics(seed, option));
        result.option = option;
        return result;
    }

    @Override
    protected boolean manageHiddenAutomatically() {
        return false;
    }

    @Override
    protected void beforeDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(this.getParam().isHidden());
    }

    @Override
    protected void afterDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(false);
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        if (this.textAsPath) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPixel.class, new DriverPixelSvg());
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg(this));
        this.registerDriver(UImage.class, new DriverImagePng(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
        this.registerDriver(DotPath.class, new DriverDotPathSvg());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterSvg());
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        try {
            if (metadata != null) {
                ((SvgGraphics)this.getGraphicObject()).addCommentMetadata(metadata);
            }
            if (this.option.isInteractive()) {
                ((SvgGraphics)this.getGraphicObject()).addStyle("onmouseinteractivefooter.css");
                ((SvgGraphics)this.getGraphicObject()).addScriptTag("https://cdn.jsdelivr.net/npm/@svgdotjs/svg.js@3.0/dist/svg.min.js");
                ((SvgGraphics)this.getGraphicObject()).addScript("onmouseinteractivefooter.js");
            }
            ((SvgGraphics)this.getGraphicObject()).createXml(os);
        }
        catch (TransformerException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void startGroup(Map<UGroupType, String> typeIdents) {
        ((SvgGraphics)this.getGraphicObject()).startGroup(typeIdents);
    }

    @Override
    public void closeGroup() {
        ((SvgGraphics)this.getGraphicObject()).closeGroup();
    }

    @Override
    public void startUrl(Url url) {
        ((SvgGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip(), this.option.getLinkTarget());
    }

    @Override
    public void closeUrl() {
        ((SvgGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    protected void drawComment(UComment comment) {
        ((SvgGraphics)this.getGraphicObject()).addComment(comment.getComment());
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        if (propertyName.equalsIgnoreCase("SVG")) {
            return true;
        }
        return super.matchesProperty(propertyName);
    }
}

