/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.visio;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.visio.VisioShape;

public class VisioRectangle
implements VisioShape {
    private final int id;
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public static VisioRectangle createInches(int id, double x, double y, double width, double height) {
        return new VisioRectangle(id, VisioRectangle.toInches(x), VisioRectangle.toInches(y), VisioRectangle.toInches(width), VisioRectangle.toInches(height));
    }

    private VisioRectangle(int id, double x, double y, double width, double height) {
        if (x < 0.0 || y < 0.0 || width < 0.0 || height < 0.0) {
            // empty if block
        }
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public VisioShape yReverse(double maxY) {
        double y2 = maxY - (this.y + this.height);
        return new VisioRectangle(this.id, this.x, y2, this.width, this.height);
    }

    private static double toInches(double val) {
        return val / 72.0;
    }

    @Override
    public void print(OutputStream os) throws IOException {
        this.out(os, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='3' FillStyle='3' TextStyle='3'>");
        this.out(os, "<XForm>");
        this.out(os, "<PinX>" + (this.x + this.width / 2.0) + "</PinX>");
        this.out(os, "<PinY>" + (this.y + this.height / 2.0) + "</PinY>");
        this.out(os, "<Width>" + this.width + "</Width>");
        this.out(os, "<Height>" + this.height + "</Height>");
        this.out(os, "<Angle>0</Angle>");
        this.out(os, "<FlipX>0</FlipX>");
        this.out(os, "<FlipY>0</FlipY>");
        this.out(os, "<ResizeMode>0</ResizeMode>");
        this.out(os, "</XForm>");
        this.out(os, "<Geom IX='0'>");
        this.out(os, "<NoFill>0</NoFill>");
        this.out(os, "<NoLine>0</NoLine>");
        this.out(os, "<NoShow>0</NoShow>");
        this.out(os, "<NoSnap>0</NoSnap>");
        this.out(os, "<MoveTo IX='1'>");
        this.out(os, "<X F='Width*0'>0</X>");
        this.out(os, "<Y F='Height*0'>0</Y>");
        this.out(os, "</MoveTo>");
        this.out(os, "<LineTo IX='2'>");
        this.out(os, "<X F='Width*1'>" + this.width + "</X>");
        this.out(os, "<Y F='Height*0'>0</Y>");
        this.out(os, "</LineTo>");
        this.out(os, "<LineTo IX='3'>");
        this.out(os, "<X F='Width*1'>" + this.width + "</X>");
        this.out(os, "<Y F='Height*1'>" + this.height + "</Y>");
        this.out(os, "</LineTo>");
        this.out(os, "<LineTo IX='4'>");
        this.out(os, "<X F='Width*0'>0</X>");
        this.out(os, "<Y F='Height*1'>" + this.height + "</Y>");
        this.out(os, "</LineTo>");
        this.out(os, "<LineTo IX='5'>");
        this.out(os, "<X F='Geometry1.X1'>0</X>");
        this.out(os, "<Y F='Geometry1.Y1'>0</Y>");
        this.out(os, "</LineTo>");
        this.out(os, "</Geom>");
        this.out(os, "</Shape>");
    }

    private void out(OutputStream os, String s2) throws IOException {
        os.write(s2.getBytes());
        os.write("\n".getBytes());
    }
}

