/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import znaishaded.net.atmp.SpecialText;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;

public class BigFrame
extends AbstractTextBlock {
    private final TextBlock title;
    private final double width;
    private final double height;
    private final Fashion symbolContext;

    public BigFrame(TextBlock title, double width, double height, Fashion symbolContext) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.symbolContext = symbolContext;
    }

    private double getYpos(XDimension2D dimTitle) {
        if (dimTitle.getWidth() == 0.0) {
            return 12.0;
        }
        return dimTitle.getHeight() + 3.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        int cornersize;
        double textWidth;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        ug = this.symbolContext.apply(ug);
        XDimension2D dimTitle = this.title.calculateDimension(stringBounder);
        double widthFull = dim.getWidth();
        URectangle rectangle = URectangle.build(widthFull, dim.getHeight()).rounded(this.symbolContext.getRoundCorner()).ignoreForCompressionOnX().ignoreForCompressionOnY();
        rectangle.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug.draw(rectangle);
        if (dimTitle.getWidth() == 0.0) {
            textWidth = widthFull / 3.0;
            cornersize = 7;
        } else {
            textWidth = dimTitle.getWidth() + 10.0;
            cornersize = 10;
        }
        double textHeight = this.getYpos(dimTitle);
        UPath line = UPath.none();
        line.setIgnoreForCompressionOnX();
        line.moveTo(textWidth, 0.0);
        line.lineTo(textWidth, textHeight - (double)cornersize);
        line.lineTo(textWidth - (double)cornersize, textHeight);
        line.lineTo(0.0, textHeight);
        ug.apply(HColors.none().bg()).draw(line);
        double widthTitle = this.title.calculateDimension(stringBounder).getWidth();
        if (widthFull - widthTitle < 25.0) {
            this.title.drawU(ug.apply(new UTranslate(3.0, 1.0)));
        } else {
            ug.apply(new UTranslate(3.0, 1.0)).draw(new SpecialText(this.title));
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.width, this.height);
    }
}

