/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.quantization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.quantization.ColorQuantizer;
import znaishaded.net.sourceforge.plantuml.quantization.HashMultiset;
import znaishaded.net.sourceforge.plantuml.quantization.Multiset;
import znaishaded.net.sourceforge.plantuml.quantization.QColor;

public final class KMeansQuantizer
implements ColorQuantizer {
    public static final KMeansQuantizer INSTANCE = new KMeansQuantizer();

    private KMeansQuantizer() {
    }

    @Override
    public Set<QColor> quantize(Multiset<QColor> originalColors, int maxColorCount) {
        LinkedHashMap<QColor, Multiset<QColor>> clustersByCentroid = new LinkedHashMap<QColor, Multiset<QColor>>();
        Set<QColor> centroidsToRecompute = KMeansQuantizer.getInitialCentroids(originalColors, maxColorCount);
        for (QColor centroid : centroidsToRecompute) {
            clustersByCentroid.put(centroid, new HashMultiset());
        }
        for (QColor color : originalColors.getDistinctElements()) {
            int count = originalColors.count(color);
            ((Multiset)clustersByCentroid.get(color.getNearestColor(centroidsToRecompute))).add(color, count);
        }
        while (!centroidsToRecompute.isEmpty()) {
            KMeansQuantizer.recomputeCentroids(clustersByCentroid, centroidsToRecompute);
            centroidsToRecompute.clear();
            Set<QColor> allCentroids = clustersByCentroid.keySet();
            for (QColor centroid : clustersByCentroid.keySet()) {
                Multiset cluster = (Multiset)clustersByCentroid.get(centroid);
                for (QColor color : new ArrayList(cluster.getDistinctElements())) {
                    QColor newCentroid = color.getNearestColor(allCentroids);
                    if (newCentroid == centroid) continue;
                    int count = cluster.count(color);
                    Multiset newCluster = (Multiset)clustersByCentroid.get(newCentroid);
                    cluster.remove(color, count);
                    newCluster.add(color, count);
                    centroidsToRecompute.add(centroid);
                    centroidsToRecompute.add(newCentroid);
                }
            }
        }
        return clustersByCentroid.keySet();
    }

    private static void recomputeCentroids(Map<QColor, Multiset<QColor>> clustersByCentroid, Set<QColor> centroidsToRecompute) {
        for (QColor oldCentroid : centroidsToRecompute) {
            Multiset<QColor> cluster = clustersByCentroid.get(oldCentroid);
            QColor newCentroid = QColor.getCentroid(cluster);
            clustersByCentroid.remove(oldCentroid);
            clustersByCentroid.put(newCentroid, cluster);
        }
    }

    private static Set<QColor> getInitialCentroids(Multiset<QColor> originalColors, int maxColorCount) {
        ArrayList<QColor> colorList = new ArrayList<QColor>(originalColors.getDistinctElements());
        Collections.shuffle(colorList);
        return new HashSet<QColor>(colorList.subList(0, maxColorCount));
    }
}

