/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.quantization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.quantization.ArbitraryComparator;
import znaishaded.net.sourceforge.plantuml.quantization.ColorQuantizer;
import znaishaded.net.sourceforge.plantuml.quantization.HashMultiset;
import znaishaded.net.sourceforge.plantuml.quantization.Multiset;
import znaishaded.net.sourceforge.plantuml.quantization.QColor;

public final class MedianCutQuantizer
implements ColorQuantizer {
    public static final MedianCutQuantizer INSTANCE = new MedianCutQuantizer();

    private MedianCutQuantizer() {
    }

    @Override
    public Set<QColor> quantize(Multiset<QColor> originalColors, int maxColorCount) {
        TreeSet<Cluster> clusters = new TreeSet<Cluster>(new ClusterSpreadComparator());
        clusters.add(new Cluster(originalColors));
        while (clusters.size() < maxColorCount) {
            Cluster clusterWithLargestSpread = clusters.pollFirst();
            clusters.addAll(clusterWithLargestSpread.split());
        }
        HashSet<QColor> clusterCentroids = new HashSet<QColor>();
        for (Cluster cluster : clusters) {
            clusterCentroids.add(QColor.getCentroid(cluster.colors));
        }
        return clusterCentroids;
    }

    static final class ClusterSpreadComparator
    implements Comparator<Cluster> {
        ClusterSpreadComparator() {
        }

        @Override
        public int compare(Cluster a, Cluster b) {
            double spreadDifference = b.largestSpread - a.largestSpread;
            if (spreadDifference == 0.0) {
                return ArbitraryComparator.INSTANCE.compare(a, b);
            }
            return (int)Math.signum(spreadDifference);
        }
    }

    private static final class Cluster {
        final Multiset<QColor> colors;
        double largestSpread;
        int componentWithLargestSpread;

        Cluster(Multiset<QColor> colors) {
            this.colors = colors;
            this.largestSpread = -1.0;
            for (int component = 0; component < 3; ++component) {
                double componentSpread = this.getComponentSpread(component);
                if (!(componentSpread > this.largestSpread)) continue;
                this.largestSpread = componentSpread;
                this.componentWithLargestSpread = component;
            }
        }

        double getComponentSpread(int component) {
            double min2 = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (QColor color : this.colors) {
                min2 = Math.min(min2, color.getComponent(component));
                max = Math.max(max, color.getComponent(component));
            }
            return max - min2;
        }

        Collection<Cluster> split() {
            ArrayList<QColor> orderedColors = new ArrayList<QColor>(this.colors);
            Collections.sort(orderedColors, new ColorComponentComparator(this.componentWithLargestSpread));
            int medianIndex = orderedColors.size() / 2;
            return Arrays.asList(new Cluster(new HashMultiset<QColor>(orderedColors.subList(0, medianIndex))), new Cluster(new HashMultiset<QColor>(orderedColors.subList(medianIndex, orderedColors.size()))));
        }
    }

    static final class ColorComponentComparator
    implements Comparator<QColor> {
        final int component;

        ColorComponentComparator(int component) {
            this.component = component;
        }

        @Override
        public int compare(QColor a, QColor b) {
            double componentDifference = a.getComponent(this.component) - b.getComponent(this.component);
            if (componentDifference == 0.0) {
                return ArbitraryComparator.INSTANCE.compare(a, b);
            }
            return (int)Math.signum(componentDifference);
        }
    }
}

