/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.quantization;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.quantization.FloydSteinbergDitherer;
import znaishaded.net.sourceforge.plantuml.quantization.MedianCutQuantizer;
import znaishaded.net.sourceforge.plantuml.quantization.Multiset;
import znaishaded.net.sourceforge.plantuml.quantization.QColor;
import znaishaded.net.sourceforge.plantuml.quantization.QImage;

public final class Quantizer {
    private static final int MAX_COLOR_COUNT = 256;

    private static QImage quantizeNow(QImage image) throws IOException {
        Multiset<QColor> originalColors = image.getColors();
        Set<QColor> distinctColors = originalColors.getDistinctElements();
        if (distinctColors.size() > 256) {
            distinctColors = MedianCutQuantizer.INSTANCE.quantize(originalColors, 256);
            image = FloydSteinbergDitherer.INSTANCE.dither(image, distinctColors);
        }
        return image;
    }

    public static BufferedImage quantizeNow(ColorMapper mapper, BufferedImage orig) throws IOException {
        QImage raw = QImage.fromBufferedImage(mapper, orig);
        QImage result = Quantizer.quantizeNow(raw);
        if (orig.getType() == 1) {
            return result.toBufferedImage();
        }
        if (orig.getType() == 2) {
            return result.toBufferedImageKeepTransparency(orig);
        }
        throw new IllegalArgumentException();
    }
}

