/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.factory;

import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.salt.DataSource;
import znaishaded.net.sourceforge.plantuml.salt.Terminated;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementText;
import znaishaded.net.sourceforge.plantuml.salt.factory.ElementFactory;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementFactoryText
implements ElementFactory {
    private final DataSource dataSource;
    private final ISkinSimple spriteContainer;

    public ElementFactoryText(DataSource dataSource, ISkinSimple spriteContainer) {
        this.dataSource = dataSource;
        this.spriteContainer = spriteContainer;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated next = (Terminated)this.dataSource.next();
        String text = (String)next.getElement();
        UFont font = UFont.byDefault(12);
        return new Terminated<Element>(new ElementText(Arrays.asList(text), font, this.spriteContainer), next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.dataSource.peek(0).getElement();
        if (text.startsWith("{") || text.startsWith("}")) {
            return false;
        }
        return StringUtils.trin(text).length() > 0;
    }
}

