/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Divider;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.HSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageExo;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Newpage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Notes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationExoTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteBottom;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteLeft;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteRight;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteTop;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelfNoteRight;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.DelayTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.DividerTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EmptyTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.HSpaceTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NewpageTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NoteTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NotesTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ReferenceTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class TileBuilder {
    public static List<Tile> buildSeveral(Iterator<Event> it, TileArguments tileArguments, Tile parent, YGauge currentY) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        while (it.hasNext()) {
            Event ev = it.next();
            for (Tile tile : TileBuilder.buildOne(it, tileArguments, ev, parent, currentY)) {
                tiles.add(tile);
                Real real = tile.getMaxX();
            }
        }
        return Collections.unmodifiableList(tiles);
    }

    public static List<Tile> buildOne(Iterator<Event> it, TileArguments tileArguments, Event ev, Tile parent, YGauge currentY) {
        StringBounder stringBounder = tileArguments.getStringBounder();
        Rose skin = tileArguments.getSkin();
        ISkinParam skinParam = tileArguments.getSkinParam();
        LivingSpaces livingSpaces = tileArguments.getLivingSpaces();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        if (ev instanceof Message) {
            Message msg = (Message)ev;
            LivingSpace livingSpace1 = livingSpaces.get(msg.getParticipant1());
            LivingSpace livingSpace2 = livingSpaces.get(msg.getParticipant2());
            boolean reverse = false;
            AbstractTile result = null;
            if (msg.isSelfMessage()) {
                result = new CommunicationTileSelf(tileArguments.getStringBounder(), livingSpace1, msg, skin, skinParam, livingSpaces, currentY);
            } else {
                result = new CommunicationTile(tileArguments.getStringBounder(), livingSpaces, msg, skin, skinParam, currentY);
                reverse = ((CommunicationTile)result).isReverse(stringBounder);
            }
            for (Note noteOnMessage : msg.getNoteOnMessages()) {
                NotePosition notePosition = noteOnMessage.getPosition();
                if (notePosition == NotePosition.LEFT) {
                    result = new CommunicationTileNoteLeft(result, msg, skin, skinParam, reverse ? livingSpace2 : livingSpace1, noteOnMessage, currentY);
                    continue;
                }
                if (notePosition == NotePosition.RIGHT && msg.isSelfMessage()) {
                    result = new CommunicationTileSelfNoteRight((CommunicationTileSelf)result, msg, skin, skinParam, noteOnMessage, currentY);
                    continue;
                }
                if (notePosition == NotePosition.RIGHT) {
                    result = new CommunicationTileNoteRight(result, msg, skin, skinParam, reverse ? livingSpace1 : livingSpace2, noteOnMessage, currentY);
                    continue;
                }
                if (notePosition == NotePosition.BOTTOM) {
                    result = new CommunicationTileNoteBottom(result, msg, skin, skinParam, noteOnMessage, currentY);
                    continue;
                }
                if (notePosition != NotePosition.TOP) continue;
                result = new CommunicationTileNoteTop(result, msg, skin, skinParam, noteOnMessage, currentY);
            }
            tiles.add(result);
        } else if (ev instanceof MessageExo) {
            MessageExo exo = (MessageExo)ev;
            LivingSpace livingSpace1 = livingSpaces.get(exo.getParticipant());
            AbstractTile result = null;
            result = new CommunicationExoTile(livingSpace1, exo, skin, skinParam, tileArguments, currentY);
            for (Note noteOnMessage : exo.getNoteOnMessages()) {
                NotePosition notePosition = exo.getNoteOnMessages().get(0).getPosition();
                if (notePosition == NotePosition.LEFT) {
                    result = new CommunicationTileNoteLeft(result, exo, skin, skinParam, livingSpace1, noteOnMessage, currentY);
                    continue;
                }
                if (notePosition != NotePosition.RIGHT) continue;
                result = new CommunicationTileNoteRight(result, exo, skin, skinParam, livingSpace1, noteOnMessage, currentY);
            }
            tiles.add(result);
        } else if (ev instanceof Note) {
            LivingSpace livingSpace2;
            Note note = (Note)ev;
            LivingSpace livingSpace1 = livingSpaces.get(note.getParticipant());
            LivingSpace livingSpace = livingSpace2 = note.getParticipant2() == null ? null : livingSpaces.get(note.getParticipant2());
            if (livingSpace1 == null && livingSpace2 == null) {
                livingSpace1 = tileArguments.getFirstLivingSpace();
                livingSpace2 = tileArguments.getLastLivingSpace();
            }
            tiles.add(new NoteTile(tileArguments.getStringBounder(), livingSpace1, livingSpace2, note, skin, skinParam, currentY));
        } else if (ev instanceof Notes) {
            Notes notes = (Notes)ev;
            tiles.add(new NotesTile(tileArguments.getStringBounder(), livingSpaces, notes, skin, skinParam, currentY));
        } else if (ev instanceof Divider) {
            Divider divider = (Divider)ev;
            tiles.add(new DividerTile(divider, tileArguments, currentY));
        } else if (ev instanceof GroupingStart) {
            GroupingStart start = (GroupingStart)ev;
            GroupingTile groupingTile = new GroupingTile(it, start, tileArguments.withBackColorGeneral(start.getBackColorElement(), start.getBackColorGeneral()), tileArguments, currentY);
            tiles.add(new EmptyTile(4.0, groupingTile, currentY));
            tiles.add(groupingTile);
            tiles.add(new EmptyTile(4.0, groupingTile, currentY));
        } else if (ev instanceof GroupingLeaf && ((GroupingLeaf)ev).getType() == GroupingType.ELSE) {
            GroupingLeaf anElse = (GroupingLeaf)ev;
            tiles.add(new ElseTile(anElse, skin, skinParam, parent, currentY));
        } else if (ev instanceof Reference) {
            Reference ref = (Reference)ev;
            tiles.add(new ReferenceTile(ref, tileArguments.withBackColor(ref), currentY));
        } else if (ev instanceof Delay) {
            Delay delay = (Delay)ev;
            tiles.add(new DelayTile(delay, tileArguments, currentY));
        } else if (ev instanceof HSpace) {
            HSpace hspace = (HSpace)ev;
            tiles.add(new HSpaceTile(hspace, tileArguments, currentY));
        } else if (ev instanceof LifeEvent) {
            LifeEvent lifeEvent = (LifeEvent)ev;
            LivingSpace livingSpace = livingSpaces.get(lifeEvent.getParticipant());
            tiles.add(new LifeEventTile(lifeEvent, tileArguments, livingSpace, skin, skinParam, currentY));
        } else if (ev instanceof Newpage) {
            Newpage newpage = (Newpage)ev;
            tiles.add(new NewpageTile(newpage, tileArguments, currentY));
        } else {
            System.err.println("TileBuilder::Ignoring " + ev.getClass());
        }
        return tiles;
    }
}

