/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.text.TLineType;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.FunctionsSet;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionType;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import znaishaded.net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorReturnFunction
extends AbstractCodeIterator {
    private final FunctionsSet functionsSet;
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorReturnFunction(CodeIterator source, TContext context, TMemory memory, FunctionsSet functionsSet, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.functionsSet = functionsSet;
        this.logs = logs;
        this.memory = memory;
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (this.functionsSet.pendingFunction() != null && this.functionsSet.pendingFunction().getFunctionType() == TFunctionType.RETURN_FUNCTION) {
                this.logs.add(result);
                if (result.getType() == TLineType.END_FUNCTION) {
                    if (!this.functionsSet.pendingFunction().doesContainReturn()) {
                        throw EaterExceptionLocated.located("This function does not have any !return directive. Declare it as a procedure instead ?", result);
                    }
                    this.functionsSet.executeEndfunction();
                } else {
                    this.functionsSet.pendingFunction().addBody(result);
                }
                this.next();
                continue;
            }
            if (result.getType() != TLineType.DECLARE_RETURN_FUNCTION) break;
            this.logs.add(result);
            this.functionsSet.executeDeclareReturnFunction(this.context, this.memory, result);
            this.next();
        }
        return result;
    }
}

