/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.json.JsonArray;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class GetJsonKey
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%get_json_keys", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        TValue data = values.get(0);
        if (!data.isJson()) {
            throw EaterException.unlocated("Not JSON data");
        }
        JsonValue json = data.toJson();
        if (json.isObject()) {
            JsonObject object = (JsonObject)json;
            JsonArray result = new JsonArray();
            for (String key : object.names()) {
                result.add(key);
            }
            return TValue.fromJson(result);
        }
        if (json.isArray()) {
            JsonArray array = (JsonArray)json;
            JsonArray result = new JsonArray();
            for (JsonValue tmp : array) {
                JsonObject object = (JsonObject)tmp;
                for (String key : object.names()) {
                    result.add(key);
                }
            }
            return TValue.fromJson(result);
        }
        throw EaterException.unlocated("Bad JSON type");
    }
}

