/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmi;

import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.decoration.LinkDecor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.xmi.XmiClassDiagramAbstract;
import znaishaded.net.sourceforge.plantuml.xmi.XmlDiagramTransformer;

public class XmiClassDiagramArgo
extends XmiClassDiagramAbstract
implements XmlDiagramTransformer {
    public XmiClassDiagramArgo(ClassDiagram classDiagram) throws ParserConfigurationException {
        super(classDiagram);
        this.addPackage(this.ownedElementRoot, classDiagram.getRootGroup());
        for (Link link : classDiagram.getLinks()) {
            this.addLink(link);
        }
    }

    protected final Element createElementPackage(Entity group) {
        Element umlPackage = this.document.createElement("UML:Package");
        umlPackage.setAttribute("xmi.id", group.getUid());
        umlPackage.setAttribute("name", group.getDisplay().get(0).toString());
        Element namespaceOwnedElement = this.document.createElement("UML:Namespace.ownedElement");
        umlPackage.appendChild(namespaceOwnedElement);
        this.addPackage(namespaceOwnedElement, group);
        return umlPackage;
    }

    private void addPackage(Element element, Entity group) {
        for (Entity ent : group.leafs()) {
            Element cla = this.createEntityNode(ent);
            if (cla == null) continue;
            element.appendChild(cla);
            this.done.add(ent);
        }
        for (Entity childGroup : group.groups()) {
            Element result = this.createElementPackage(childGroup);
            element.appendChild(result);
            this.done.add(childGroup);
        }
    }

    private void addLink(Link link) {
        if (link.isHidden() || link.isInvis()) {
            return;
        }
        String assId = "ass" + this.classDiagram.getUniqueSequence();
        if (link.getType().getDecor1() == LinkDecor.EXTENDS || link.getType().getDecor2() == LinkDecor.EXTENDS) {
            this.addExtension(link, assId);
            return;
        }
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        if (!Display.isNull(link.getLabel())) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.document.createElement("UML:AssociationEnd");
        end1.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end1.setAttribute("association", assId);
        end1.setAttribute("type", link.getEntity1().getUid());
        if (link.getQuantifier1() != null) {
            end1.setAttribute("name", this.forXMI(link.getQuantifier1()));
        }
        Element endparticipant1 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            end1.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            end1.setAttribute("aggregation", "aggregate");
        }
        end1.appendChild(endparticipant1);
        connection.appendChild(end1);
        Element end2 = this.document.createElement("UML:AssociationEnd");
        end2.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end2.setAttribute("association", assId);
        end2.setAttribute("type", link.getEntity2().getUid());
        if (link.getQuantifier2() != null) {
            end2.setAttribute("name", this.forXMI(link.getQuantifier2()));
        }
        Element endparticipant2 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            end2.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            end2.setAttribute("aggregation", "aggregate");
        }
        end2.appendChild(endparticipant2);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElementRoot.appendChild(association);
    }

    private void addExtension(Link link, String assId) {
        Element association = this.document.createElement("UML:Generalization");
        association.setAttribute("xmi.id", assId);
        if (link.getLabel() != null) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        if (link.getType().getDecor1() == LinkDecor.EXTENDS) {
            this.generalizationChildParent(association, link.getEntity1().getUid(), link.getEntity2().getUid());
        } else if (link.getType().getDecor2() == LinkDecor.EXTENDS) {
            this.generalizationChildParent(association, link.getEntity2().getUid(), link.getEntity1().getUid());
        } else {
            throw new IllegalStateException();
        }
        this.ownedElementRoot.appendChild(association);
    }

    private void generalizationChildParent(Element association, String uidChild, String uidParent) {
        Element child = this.document.createElement("UML:Generalization.child");
        Element parent = this.document.createElement("UML:Generalization.parent");
        Element classChild = this.document.createElement("UML:Class");
        classChild.setAttribute("xmi.idref", uidChild);
        Element classParent = this.document.createElement("UML:Class");
        classParent.setAttribute("xmi.idref", uidParent);
        parent.appendChild(classParent);
        child.appendChild(classChild);
        association.appendChild(child);
        association.appendChild(parent);
    }

    private void addLinkLegacyUnused(Link link) {
        if (link.isHidden() || link.isInvis()) {
            return;
        }
        String assId = "ass" + this.classDiagram.getUniqueSequence();
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        if (link.getLabel() != null) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.document.createElement("UML:AssociationEnd");
        end1.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end1.setAttribute("association", assId);
        end1.setAttribute("type", link.getEntity1().getUid());
        if (link.getQuantifier1() != null) {
            end1.setAttribute("name", this.forXMI(link.getQuantifier1()));
        }
        Element endparticipant1 = this.document.createElement("UML:AssociationEnd.participant");
        if (this.done.contains(link.getEntity1())) {
            endparticipant1.appendChild(this.createEntityNodeRef(link.getEntity1()));
        } else {
            Element element = this.createEntityNode(link.getEntity1());
            if (element == null) {
                return;
            }
            endparticipant1.appendChild(element);
            this.done.add(link.getEntity1());
        }
        end1.appendChild(endparticipant1);
        connection.appendChild(end1);
        Element end2 = this.document.createElement("UML:AssociationEnd");
        end2.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end2.setAttribute("association", assId);
        end2.setAttribute("type", link.getEntity2().getUid());
        if (link.getQuantifier2() != null) {
            end2.setAttribute("name", this.forXMI(link.getQuantifier2()));
        }
        Element endparticipant2 = this.document.createElement("UML:AssociationEnd.participant");
        if (this.done.contains(link.getEntity2())) {
            endparticipant2.appendChild(this.createEntityNodeRef(link.getEntity2()));
        } else {
            Element element = this.createEntityNode(link.getEntity2());
            if (element == null) {
                return;
            }
            endparticipant2.appendChild(element);
            this.done.add(link.getEntity2());
        }
        end2.appendChild(endparticipant2);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElementRoot.appendChild(association);
    }

    private Element createEntityNodeRef(Entity entity) {
        Element cla = this.document.createElement("UML:Class");
        cla.setAttribute("xmi.idref", entity.getUid());
        return cla;
    }
}

