/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.json.JsonArray;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonString;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.yaml.YamlLines;

public class SimpleYamlParser {
    private JsonValue result;
    private final List<Integer> pendingIndents = new ArrayList<Integer>();

    public JsonValue parse(List<String> lines) {
        this.result = new JsonObject();
        this.pendingIndents.clear();
        this.pendingIndents.add(0);
        YamlLines yamlLines = new YamlLines(lines);
        for (String s2 : yamlLines) {
            this.parseSingleLine(s2);
        }
        return this.result;
    }

    private String[] nameAndValue(String s2) {
        Pattern p1 = Pattern.compile("^\\s*([^:]+)\\s*: \\s*(\\S.*)$");
        Matcher m1 = p1.matcher(s2);
        if (m1.matches()) {
            String name = m1.group(1);
            String data = m1.group(2).trim();
            return new String[]{name, data};
        }
        return null;
    }

    private void parseSingleLine(String s2) {
        int indent = this.getIndent(s2);
        if (this.isListStrict(s2)) {
            this.strictMuteToArray(indent);
            return;
        }
        String listedValue = this.listedValue(s2);
        if (listedValue != null) {
            JsonArray array = this.getForceArray(indent);
            array.add(listedValue);
            return;
        }
        JsonObject working = (JsonObject)this.getWorking(indent);
        if (working == null) {
            System.err.println("ERROR: ignoring " + s2);
            return;
        }
        String[] nameAndValue = this.nameAndValue(s2);
        if (nameAndValue != null) {
            String name = nameAndValue[0];
            String data = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(nameAndValue[1], "\"");
            working.add(name, data);
            return;
        }
        String nameOnly = YamlLines.nameOnly(s2);
        if (nameOnly != null) {
            working.add(nameOnly, new JsonObject());
            return;
        }
        throw new UnsupportedOperationException(s2);
    }

    private String listedValue(String s2) {
        Pattern p1 = Pattern.compile("^\\s*[-]\\s*(\\S.*)$");
        Matcher m1 = p1.matcher(s2);
        if (m1.matches()) {
            String name = m1.group(1).trim();
            return name;
        }
        return null;
    }

    private JsonArray getForceArray(int indent) {
        String field;
        if (indent == 0 && this.getLastIndent() == 0) {
            if (!(this.result instanceof JsonArray)) {
                this.result = new JsonArray();
            }
            return (JsonArray)this.result;
        }
        while (this.getLastIndent() > indent - 1) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        JsonObject last = (JsonObject)SimpleYamlParser.search(this.result, this.pendingIndents.size());
        if (!(last.get(field = last.names().get(last.size() - 1)) instanceof JsonArray)) {
            last.set(field, new JsonArray());
        }
        return (JsonArray)last.get(field);
    }

    private void strictMuteToArray(int indent) {
        String field;
        if (indent == 0 && this.getLastIndent() == 0) {
            if (!(this.result instanceof JsonArray)) {
                this.result = new JsonArray();
            }
            return;
        }
        while (this.getLastIndent() > indent) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        if (this.result instanceof JsonArray) {
            ((JsonArray)this.result).add(new JsonObject());
            return;
        }
        JsonObject last = (JsonObject)SimpleYamlParser.search(this.result, this.pendingIndents.size());
        if (!(last.get(field = last.names().get(last.size() - 1)) instanceof JsonArray)) {
            last.set(field, new JsonArray());
        } else {
            ((JsonArray)last.get(field)).add(new JsonObject());
        }
    }

    private boolean isListStrict(String s2) {
        return s2.trim().equals("-");
    }

    private int getLastIndent() {
        return this.pendingIndents.get(this.pendingIndents.size() - 1);
    }

    private JsonValue getWorking(int indent) {
        if (indent > this.getLastIndent()) {
            this.pendingIndents.add(indent);
            return SimpleYamlParser.search(this.result, this.pendingIndents.size());
        }
        if (indent == this.getLastIndent()) {
            return SimpleYamlParser.search(this.result, this.pendingIndents.size());
        }
        int idx = this.pendingIndents.indexOf(indent);
        if (idx == -1) {
            return null;
        }
        while (this.pendingIndents.size() > idx + 1) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        return SimpleYamlParser.search(this.result, this.pendingIndents.size());
    }

    private static JsonValue search(JsonValue current1, int size) {
        if (current1 instanceof JsonArray) {
            JsonValue tmp;
            JsonArray array = (JsonArray)current1;
            if (array.size() == 0) {
                tmp = new JsonObject();
                array.add(tmp);
            } else {
                tmp = array.get(array.size() - 1);
            }
            return tmp;
        }
        if (size <= 1) {
            return current1;
        }
        JsonObject current = (JsonObject)current1;
        String last = current.names().get(current.size() - 1);
        JsonValue tmp = current.get(last);
        if (tmp instanceof JsonArray) {
            JsonArray array = (JsonArray)tmp;
            if (array.size() == 0) {
                tmp = new JsonObject();
                array.add(tmp);
            } else {
                tmp = array.get(array.size() - 1);
            }
        }
        if (tmp instanceof JsonString) {
            System.err.println("JsonString? " + tmp);
            return null;
        }
        return SimpleYamlParser.search(tmp, size - 1);
    }

    private int getIndent(String s2) {
        int indent = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (ch == ' ' || ch == '\t') {
                ++indent;
                continue;
            }
            return indent;
        }
        return 0;
    }
}

