/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.charts;

import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.charts.ChartData;
import org.testingisdocumenting.znai.charts.ChartDataCsvParser;
import org.testingisdocumenting.znai.charts.ChartIncludeBasePlugin;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;

class ChartPluginResult {
    private ChartPluginResult() {
    }

    static PluginResult create(PluginParams pluginParams, String type, String csvContent) {
        ChartData chartData = ChartDataCsvParser.parse(csvContent);
        List columns = pluginParams.getOpts().getList(ChartIncludeBasePlugin.COLUMNS);
        if (!columns.isEmpty()) {
            for (Object column : columns) {
                if (chartData.getLabels().contains(column.toString())) continue;
                throw new IllegalArgumentException("column <" + column + "> does not exist");
            }
            List<Integer> indexesToDelete = chartData.getLabels().stream().filter(col -> !columns.contains(col)).map(col -> chartData.getLabels().indexOf(col)).sorted(Comparator.reverseOrder()).toList();
            if (!indexesToDelete.isEmpty()) {
                Object column;
                column = indexesToDelete.iterator();
                while (column.hasNext()) {
                    int n = (Integer)column.next();
                    chartData.getLabels().remove(n);
                }
                for (List list : chartData.getData()) {
                    for (int idx : indexesToDelete) {
                        list.remove(idx);
                    }
                }
            }
        }
        List<List<Object>> data = chartData.getData();
        List<Object> breakpoints = pluginParams.getOpts().getList(ChartIncludeBasePlugin.BREAKPOINT_KEY);
        boolean bl = pluginParams.getOpts().get(ChartIncludeBasePlugin.TIME_KEY, false);
        ChartPluginResult.validateBreakpoints(breakpoints, data);
        List<Object> convertedBreakpoints = ChartPluginResult.convertAllBreakpointsToActualValues(breakpoints, data);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        props.put("chartType", type);
        props.put("isTimeSeries", bl);
        if (!breakpoints.isEmpty()) {
            props.put("breakpoint", convertedBreakpoints);
        }
        props.putAll(chartData.toMap());
        return PluginResult.docElement("EchartGeneric", props);
    }

    private static List<Object> convertAllBreakpointsToActualValues(List<Object> breakpoints, List<List<Object>> data) {
        if (!ChartPluginResult.isAllBreakpoints(breakpoints)) {
            return breakpoints;
        }
        if (data.stream().anyMatch(row -> row.get(0) instanceof Number)) {
            throw new IllegalArgumentException("<all> breakpoint is not supported for numerical data");
        }
        return data.stream().limit(data.size() - 1).map(row -> row.get(0)).collect(Collectors.toList());
    }

    private static void validateBreakpoints(List<Object> breakpoints, List<List<Object>> data) {
        if (breakpoints.isEmpty() || ChartPluginResult.isAllBreakpoints(breakpoints)) {
            return;
        }
        if (data.isEmpty()) {
            return;
        }
        Stream<Object> mainAxisValues = data.stream().map(row -> row.get(0));
        if (breakpoints.get(0) instanceof String) {
            ChartPluginResult.validateTextBreakPoints(breakpoints, mainAxisValues);
        } else {
            ChartPluginResult.validateNumericBreakpoints(breakpoints, mainAxisValues);
        }
    }

    private static void validateTextBreakPoints(List<Object> breakpoints, Stream<Object> mainAxisValues) {
        Set uniqueValues = mainAxisValues.map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Object breakpoint : breakpoints) {
            if (uniqueValues.contains(breakpoint.toString())) continue;
            throw new IllegalArgumentException("breakpoint value <" + breakpoint + "> is not found, available values:\n  " + String.join((CharSequence)"\n  ", uniqueValues));
        }
    }

    private static void validateNumericBreakpoints(List<Object> breakpoints, Stream<Object> mainAxisValues) {
        DoubleSummaryStatistics statistics = mainAxisValues.collect(Collectors.summarizingDouble(v -> ((Number)v).doubleValue()));
        for (Object breakpoint : breakpoints) {
            double breakpointNumber = ((Number)breakpoint).doubleValue();
            if (!(breakpointNumber < statistics.getMin()) && !(breakpointNumber > statistics.getMax())) continue;
            throw new IllegalArgumentException("breakpoint <" + breakpointNumber + "> is outside of range [" + statistics.getMin() + ", " + statistics.getMax() + "]");
        }
    }

    private static boolean isAllBreakpoints(List<Object> breakpoints) {
        return breakpoints.size() == 1 && breakpoints.get(0).equals("all");
    }
}

