/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.diagrams.graphviz.gen.DiagramEdge;
import org.testingisdocumenting.znai.diagrams.graphviz.gen.DiagramNode;
import org.testingisdocumenting.znai.diagrams.graphviz.gen.GraphvizGenConfig;
import org.testingisdocumenting.znai.diagrams.graphviz.gen.GraphvizGenResult;
import org.testingisdocumenting.znai.diagrams.graphviz.gen.NodesConfig;
import org.testingisdocumenting.znai.utils.StringUtils;

public class GraphvizFromJsonGen {
    private final Map<String, DiagramNode> nodesFromGraph;
    private final Map<String, DiagramNode> nodesFromLibs;
    private final List<DiagramEdge> edgesFromGraph;
    private final GraphvizGenConfig config;
    private final NodesConfig nodesConfig;

    public GraphvizFromJsonGen(Map<String, ?> graph, List<List<?>> nodesLibraries, GraphvizGenConfig config) {
        this.config = config;
        this.nodesFromGraph = this.extractNodesFromGraph(graph);
        this.edgesFromGraph = this.extractEdgesFromGraph(graph);
        this.nodesConfig = this.extractNodesConfig(graph);
        this.nodesFromLibs = this.organizeNodesFromLibs(nodesLibraries);
    }

    public GraphvizGenResult generate() {
        Collection<DiagramNode> referencedNodes = this.findReferencedNodes();
        String nodes = this.generateNodes(referencedNodes);
        String edges = this.generateEdges(this.edgesFromGraph);
        return new GraphvizGenResult("digraph Generated {\n" + (!this.config.isVertical() ? "rankdir=LR;\n" : "") + "bgcolor=\"#ffffff00\";\nnode [shape=record; fontsize=10; margin=0.2; fontname=Helvetica];\n" + (String)(nodes.isEmpty() ? "" : "\n" + nodes + "\n") + (String)(edges.isEmpty() ? "" : "\n" + edges + "\n") + "}", referencedNodes);
    }

    private Collection<DiagramNode> findReferencedNodes() {
        LinkedHashMap result = new LinkedHashMap();
        Consumer<String> handleNodeId = id -> {
            if (result.containsKey(id)) {
                return;
            }
            if (this.nodesFromGraph.containsKey(id)) {
                result.put(id, this.nodesFromGraph.get(id));
            }
            if (this.nodesFromLibs.containsKey(id)) {
                result.put(id, this.nodesFromLibs.get(id));
            }
        };
        this.edgesFromGraph.forEach(edge -> {
            handleNodeId.accept(edge.getFromId());
            handleNodeId.accept(edge.getToId());
        });
        return result.values();
    }

    private List<DiagramEdge> extractEdgesFromGraph(Map<String, ?> graph) {
        List edges = (List)graph.get("edges");
        if (edges == null) {
            throw new RuntimeException("edges are not specified");
        }
        return edges.stream().map(this::createEdgeFromMap).collect(Collectors.toList());
    }

    private DiagramEdge createEdgeFromMap(List<String> edge) {
        if (edge.size() < 2 || edge.size() > 3) {
            throw new IllegalArgumentException("edges definition should be in the format [from, to, optionalType] (type is either both or none)");
        }
        return new DiagramEdge(edge.get(0), edge.get(1), edge.size() == 3 ? edge.get(2) : "");
    }

    private Map<String, DiagramNode> extractNodesFromGraph(Map<String, ?> graph) {
        List nodes = (List)graph.get("nodes");
        if (nodes == null) {
            return Collections.emptyMap();
        }
        return this.groupNodesById(nodes);
    }

    private NodesConfig extractNodesConfig(Map<String, ?> graph) {
        Map config = (Map)graph.get("config");
        if (config == null) {
            return new NodesConfig();
        }
        Map nodes = (Map)config.get("nodes");
        if (nodes == null) {
            return new NodesConfig();
        }
        return new NodesConfig((Number)nodes.get("width"), (Number)nodes.get("height"));
    }

    private Map<String, DiagramNode> organizeNodesFromLibs(List<List<?>> nodesLibraries) {
        LinkedHashMap<String, DiagramNode> result = new LinkedHashMap<String, DiagramNode>();
        nodesLibraries.forEach(nodes -> result.putAll(this.groupNodesById((List<Map<String, Object>>)nodes)));
        return result;
    }

    private Map<String, DiagramNode> groupNodesById(List<Map<String, Object>> nodes) {
        return nodes.stream().collect(Collectors.toMap(n -> n.get("id").toString(), GraphvizFromJsonGen::createNode));
    }

    private static DiagramNode createNode(Map<String, Object> node) {
        Object id = node.get("id");
        if (id == null) {
            throw new RuntimeException("node id must be specified: " + node);
        }
        return new DiagramNode(id.toString(), node.getOrDefault("label", "").toString(), node.getOrDefault("url", "").toString(), node.getOrDefault("colorGroup", "").toString(), node.getOrDefault("shape", "").toString(), Boolean.TRUE.equals(node.getOrDefault("highlight", "")), (Number)node.get("width"), (Number)node.get("height"));
    }

    private String generateNodes(Collection<DiagramNode> nodes) {
        return nodes.stream().map(this::generateNode).collect(Collectors.joining("\n"));
    }

    private String generateNode(DiagramNode node) {
        return StringUtils.wrapInDoubleQuotes(node.getId()) + " [label=\"" + this.generateNodeLabel(node) + "\"" + this.generateSizeAttributesIfRequired(node) + "];";
    }

    private String generateSizeAttributesIfRequired(DiagramNode node) {
        if (!this.nodesConfig.isSizeDefined(node)) {
            return "";
        }
        StringBuilder sizeAttrs = new StringBuilder(" fixedsize=true");
        if (this.nodesConfig.isWidthDefined(node)) {
            sizeAttrs.append(" width=").append(this.nodesConfig.getWidth(node));
        }
        if (this.nodesConfig.isHeightDefined(node)) {
            sizeAttrs.append(" height=").append(this.nodesConfig.getHeight(node));
        }
        return sizeAttrs.toString();
    }

    private String generateNodeLabel(DiagramNode node) {
        ArrayList<String> metaParts = new ArrayList<String>();
        if (node.getHighlight().booleanValue()) {
            metaParts.add("h");
        } else if (!node.getColorGroup().isEmpty()) {
            metaParts.add(node.getColorGroup());
        }
        if (!node.getShape().isEmpty()) {
            metaParts.add(node.getShape());
        }
        String labelSuffix = metaParts.isEmpty() ? "" : "[" + String.join((CharSequence)" ", metaParts) + "]";
        return this.preProcessLabel(node.getLabel()) + labelSuffix;
    }

    private String generateEdges(List<DiagramEdge> edges) {
        return edges.stream().map(this::generateEdge).collect(Collectors.joining("\n"));
    }

    private String generateEdge(DiagramEdge edge) {
        return StringUtils.wrapInDoubleQuotes(edge.getFromId()) + " -> " + StringUtils.wrapInDoubleQuotes(edge.getToId()) + (String)(!edge.getDirection().isEmpty() ? "[dir=" + edge.getDirection() + "];" : ";");
    }

    private String preProcessLabel(String label) {
        return label.replace("\n", "\\n");
    }
}

