/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.tabs;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.ColonDelimitedKeyValues;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class TabsFencePlugin
implements FencePlugin {
    private Path markupPath;
    private MarkupParser parser;
    private List<String> texts;
    private List<AuxiliaryFile> auxiliaryFiles;

    @Override
    public String id() {
        return "tabs";
    }

    @Override
    public FencePlugin create() {
        return new TabsFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.markupPath = markupPath;
        this.parser = componentsRegistry.defaultParser();
        this.texts = new ArrayList<String>();
        this.auxiliaryFiles = new ArrayList<AuxiliaryFile>();
        ColonDelimitedKeyValues tabsDefinitions = new ColonDelimitedKeyValues(content);
        List<ParsedTab> parsedTabs = tabsDefinitions.map(this::parseTab).toList();
        if (parsedTabs.isEmpty()) {
            throw new IllegalStateException("no tabs are defined. if your tab names have spaces quote the tab name");
        }
        LinkedHashMap<String, Object> tabsProps = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        tabsProps.put("tabsContent", parsedTabs.stream().map(this::tabProps).collect(Collectors.toList()));
        parsedTabs.forEach(this::generateSearchText);
        parsedTabs.forEach(this::collectAuxiliaryFiles);
        return PluginResult.docElement("Tabs", tabsProps);
    }

    private Map<String, Object> tabProps(ParsedTab parsedTab) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", parsedTab.name);
        props.put("content", parsedTab.parserResult.contentToListOfMaps());
        return props;
    }

    private void generateSearchText(ParsedTab parsedTab) {
        this.texts.add(parsedTab.name);
        this.texts.add(parsedTab.parserResult.getAllText());
    }

    private void collectAuxiliaryFiles(ParsedTab parsedTab) {
        this.auxiliaryFiles.addAll(parsedTab.parserResult.auxiliaryFiles());
    }

    private ParsedTab parseTab(String tabName, String markup) {
        MarkupParserResult parserResult = this.parser.parse(this.markupPath, markup);
        return new ParsedTab(tabName, parserResult);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.auxiliaryFiles.stream();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(String.join((CharSequence)" ", this.texts));
    }

    private static class ParsedTab {
        private String name;
        private MarkupParserResult parserResult;

        private ParsedTab(String name, MarkupParserResult parserResult) {
            this.name = name;
            this.parserResult = parserResult;
        }
    }
}

