/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameter;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.openapi.OpenApi3Schema;
import org.testingisdocumenting.znai.openapi.OpenApiMarkdownParser;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class OpenApi3SchemaToApiParametersConverter {
    private final OpenApiMarkdownParser parser;
    private final OpenApi3Schema rootSchema;
    private final ApiParameters apiParameters;
    private boolean createNewParent;

    public OpenApi3SchemaToApiParametersConverter(OpenApiMarkdownParser parser, String anchorPrefix, OpenApi3Schema rootSchema) {
        this.parser = parser;
        this.rootSchema = rootSchema;
        this.apiParameters = new ApiParameters(anchorPrefix);
        this.createNewParent = true;
    }

    public ApiParameters convert() {
        this.handleSchema(this.apiParameters.getRoot(), this.rootSchema, false);
        if (this.rootSchema.getType() == null) {
            return this.apiParameters;
        }
        if (this.rootSchema.getType().equals("object")) {
            return this.apiParameters.withoutTopLevel();
        }
        return this.apiParameters;
    }

    private void handleSchema(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        String type = schema.getType();
        if (type == null) {
            return;
        }
        switch (type) {
            case "object": {
                this.handleObjectSchema(parent, schema, required);
                break;
            }
            case "anyOf": 
            case "oneOf": {
                this.handleComposeSchema(parent, schema, required);
                break;
            }
            case "array": {
                this.handleArraySchema(parent, schema, required);
                break;
            }
            default: {
                this.handleGenericSchema(parent, schema, required);
            }
        }
    }

    private void handleComposeSchema(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        ApiParameter newParent = this.addParameter(parent, schema, required);
        for (OpenApi3Schema property : schema.getProperties()) {
            this.handleSchema(newParent, property, schema.isRequired(property.getName()));
        }
    }

    private void handleObjectSchema(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        ApiParameter newParent = !this.createNewParent ? parent : this.addParameter(parent, schema, required);
        for (OpenApi3Schema property : schema.getProperties()) {
            this.handleSchema(newParent, property, schema.isRequired(property.getName()));
        }
        OpenApi3Schema additionalProperties = schema.getAdditionalProperties();
        if (additionalProperties != null) {
            this.handleSchema(newParent, schema.getAdditionalProperties(), false);
        }
    }

    private void handleArraySchema(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        ApiParameter newParent = this.addParameter(parent, schema, required);
        OpenApi3Schema items = schema.getItems();
        if (items.getType().equals("object")) {
            this.createNewParent = false;
            this.handleSchema(newParent, items, false);
            this.createNewParent = true;
        }
    }

    private void handleGenericSchema(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        this.addParameter(parent, schema, required);
    }

    private ApiParameter addParameter(ApiParameter parent, OpenApi3Schema schema, boolean required) {
        DocElement docElementFromDescription = this.parser.docElementFromDescription(schema.renderDescriptionWithExamplesAndEnums());
        String namePrefix = required ? "*" : "";
        return parent.add(schema.getName() + namePrefix, new ApiLinkedText(schema.renderCombinedType()), docElementFromDescription.contentToListOfMaps(), schema.getDescription());
    }
}

