/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import znaishaded.org.apache.commons.io.IOUtils;

class HttpResource {
    private final String url;
    private final String content;

    HttpResource(String url) {
        this.url = url;
        this.content = this.get();
    }

    public static boolean isHttpResource(String path) {
        return path.startsWith("http://") || path.startsWith("https://");
    }

    public String getContent() {
        return this.content;
    }

    public boolean exists() {
        return this.content != null;
    }

    private String get() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "*");
            if (connection.getResponseCode() >= 400) {
                return null;
            }
            return this.extractHttpResponse(connection);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String extractHttpResponse(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        return inputStream != null ? IOUtils.toString(inputStream, StandardCharsets.UTF_8) : "";
    }
}

