/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import java.math.BigDecimal;
import java.util.Collection;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class DivisorSyntaxChecker
extends AbstractSyntaxChecker {
    public DivisorSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        BigDecimal divisor = node.decimalValue();
        if (divisor.compareTo(BigDecimal.ZERO) <= 0) {
            report.error(this.newMsg(tree, bundle, "common.divisor.notPositive").put("found", node));
        }
    }
}

