/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.draftv4;

import java.util.EnumSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class DraftV4TypeValidator
extends AbstractKeywordValidator {
    private final EnumSet<NodeType> types = EnumSet.noneOf(NodeType.class);

    public DraftV4TypeValidator(JsonNode digest) {
        super("type");
        for (JsonNode node : digest.get(this.keyword)) {
            this.types.add(NodeType.fromName(node.textValue()));
        }
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        NodeType type = NodeType.getNodeType(data.getInstance().getNode());
        if (!this.types.contains((Object)type)) {
            report.error(this.newMsg(data, bundle, "err.common.typeNoMatch").putArgument("found", type).putArgument("expected", DraftV4TypeValidator.toArrayNode(this.types)));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.types;
    }
}

